/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.v2.view;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.theramp.v2.model.RampModel;
import edu.colorado.phet.theramp.v2.model.RampObject;
import edu.colorado.phet.theramp.v2.view.RampSimPanel;
import java.util.ArrayList;

public class TestRampModule
extends Module {
    private RampModel currentState = new RampModel();
    private ArrayList listeners = new ArrayList();

    public TestRampModule() {
        super("test ramp", new ConstantDtClock(30, 1.0));
        this.setSimulationPanel(new RampSimPanel(this));
        this.addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                TestRampModule.this.debugState();
            }
        });
    }

    private void debugState() {
        System.out.println("CurrentState=" + this.currentState);
    }

    public RampModel getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(RampModel rampModel) {
        this.currentState = rampModel;
        this.notifyListeners();
    }

    public void updateCurrentState(RampObject rampObject, RampObject rampObject2) {
        this.setCurrentState(this.getCurrentState().update(rampObject, rampObject2));
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).notifyChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void notifyChanged();
    }
}

