/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.v2.view;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.theramp.v2.model.RampModel;
import edu.colorado.phet.theramp.v2.model.RampObject;
import edu.colorado.phet.theramp.v2.view.TestRampModule;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class RampModelView
extends PNode {
    private TestRampModule module;

    public RampModelView(TestRampModule testRampModule) {
        this.module = testRampModule;
        testRampModule.addListener(new TestRampModule.Listener(){

            public void notifyChanged() {
                RampModelView.this.update();
            }
        });
        this.update();
    }

    private void update() {
        boolean bl = true;
        if (bl) {
            this.updateNewNodes();
        } else {
            this.updateOldNodes();
        }
    }

    private void updateNewNodes() {
        this.removeAllChildren();
        RampModel rampModel = this.module.getCurrentState();
        for (int i = 0; i < rampModel.getObjectCount(); ++i) {
            this.addChild(this.createNode(rampModel.getObject(i)));
        }
    }

    private void updateOldNodes() {
        if (this.getChildrenCount() == 0) {
            this.updateNewNodes();
        } else {
            this.getChild(0).translate(1.0, 1.0);
        }
    }

    private PNode createNode(final RampObject rampObject) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(rampObject.getPosition().getX(), rampObject.getPosition().getY(), 20.0, 20.0);
        PPath pPath = new PPath(double_);
        pPath.setPaint(Color.blue);
        PBasicInputEventHandler pBasicInputEventHandler = new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                super.mousePressed(pInputEvent);
                RampModelView.this.module.updateCurrentState(rampObject, rampObject.setInteracting(true));
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                super.mouseDragged(pInputEvent);
                RampObject rampObject2 = rampObject.setPosition(pInputEvent.getCanvasPosition().getX(), pInputEvent.getCanvasPosition().getY());
                RampModelView.this.module.updateCurrentState(rampObject, rampObject2);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                super.mouseReleased(pInputEvent);
                RampModelView.this.module.updateCurrentState(rampObject, rampObject.setInteracting(false));
            }
        };
        pPath.addInputEventListener(pBasicInputEventHandler);
        pPath.addInputEventListener(new CursorHandler());
        return pPath;
    }
}

