/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.timeseries;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.theramp.timeseries.Mode;
import edu.colorado.phet.theramp.timeseries.PhetTimer;
import edu.colorado.phet.theramp.timeseries.TimeSeriesModel;

public class RecordMode
extends Mode {
    private PhetTimer timer = new PhetTimer("Record Timer");
    private TimeSeriesModel timeSeriesModel;

    public RecordMode(TimeSeriesModel timeSeriesModel) {
        super(timeSeriesModel, "Record", true);
        this.timeSeriesModel = timeSeriesModel;
    }

    public void initialize() {
        this.timeSeriesModel.repaintBackground();
        double d = this.timeSeriesModel.getRecordTime();
        this.timeSeriesModel.setReplayTime(d);
        this.timeSeriesModel.repaintBackground();
    }

    public void reset() {
        this.timer.reset();
    }

    public PhetTimer getTimer() {
        return this.timer;
    }

    public void clockTicked(ClockEvent clockEvent) {
        double d = clockEvent.getSimulationTimeChange();
        double d2 = this.timer.getTime();
        double d3 = this.timeSeriesModel.getMaxAllowedTime();
        if (!this.timeSeriesModel.isPaused()) {
            double d4 = d2 + d;
            if (d4 > d3) {
                d = d3 - d2;
            }
            this.timer.stepInTime(d, d3);
            this.timeSeriesModel.updateModel(clockEvent);
        }
    }
}

