/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.theramp.model.Block;
import edu.colorado.phet.theramp.model.Ground;
import edu.colorado.phet.theramp.model.Ramp;
import edu.colorado.phet.theramp.model.RampObject;
import edu.colorado.phet.theramp.model.Surface;
import java.util.ArrayList;

public class RampPhysicalModel
implements ModelElement,
Surface.CollisionListener {
    private Surface ground;
    private Surface ramp;
    private Block block;
    private ForceVector wallForce;
    private ForceVector appliedForce;
    private ForceVector gravityForce;
    private ForceVector totalForce;
    private ForceVector frictionForce;
    private ForceVector normalForce;
    private double gravity = 9.8;
    private double appliedWork = 0.0;
    private double frictiveWork = 0.0;
    private double gravityWork = 0.0;
    private double zeroPointY = 0.0;
    private double thermalEnergy = 0.0;
    private boolean userAddingEnergy = false;
    private ArrayList listeners = new ArrayList();
    private SimpleObservable peObservers = new SimpleObservable();
    private SimpleObservable keObservers = new SimpleObservable();
    private double lastTick;
    private ModelElement stepStrategy;
    private double originalBlockKE;
    private RampPhysicalModel lastState;
    private double appliedForceSetValue = 0.0;

    public RampPhysicalModel() {
        this.ramp = new Ramp(0.09817477042468103, 15.0);
        this.ramp.addCollisionListener(this);
        this.ground = new Ground(0.0, 6.0, -6.0, 0.0, 0.0);
        this.ramp.setDistanceOffset(this.ground.getLength());
        this.ground.addCollisionListener(this);
        this.block = new Block(this.ramp);
        this.wallForce = new ForceVector();
        this.gravityForce = new ForceVector();
        this.totalForce = new ForceVector();
        this.frictionForce = new ForceVector();
        this.appliedForce = new ForceVector();
        this.normalForce = new ForceVector();
        this.setStepStrategy(new NewStepCode());
        this.setupForces();
    }

    private void updateAppliedForceValue() {
        this.setAppliedForce(this.appliedForceSetValue);
    }

    public void setStepStrategy(ModelElement modelElement) {
        this.stepStrategy = modelElement;
    }

    public Surface getRamp() {
        return this.ramp;
    }

    public Block getBlock() {
        return this.block;
    }

    public double currentTimeSeconds() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public void stepInTime(double d) {
        this.stepStrategy.stepInTime(d);
        this.updateAppliedForceValue();
    }

    private void newStepCode(double d) {
        if (this.lastTick != 0.0) {
            d = this.currentTimeSeconds() - this.lastTick;
            d = MathUtil.clamp(0.03333333333333333, d, 0.2);
            RampPhysicalModel rampPhysicalModel = this.getState();
            this.setupForces();
            double d2 = this.totalForce.getParallelComponent() / this.block.getMass();
            this.block.setAcceleration(d2);
            this.originalBlockKE = this.block.getKineticEnergy();
            this.block.stepInTime(this, d);
            if (this.block.getStaticFriction() == 0.0 && this.block.getKineticFriction() == 0.0) {
                this.appliedWork = this.getTotalEnergy();
                this.gravityWork = -this.getPotentialEnergy();
                this.thermalEnergy = rampPhysicalModel.getThermalEnergy();
                if (this.block.isJustCollided()) {
                    this.thermalEnergy += this.lastState.getKineticEnergy();
                }
                this.frictiveWork = -this.thermalEnergy;
            } else {
                double d3;
                double d4 = this.getAppliedWorkDifferential(rampPhysicalModel);
                this.appliedWork += d4;
                this.gravityWork = -this.getPotentialEnergy();
                double d5 = this.appliedWork;
                this.thermalEnergy = d5 - this.getKineticEnergy() - this.getPotentialEnergy();
                this.frictiveWork = -this.thermalEnergy;
                double d6 = this.getTotalEnergy() - this.getAppliedWork();
                if (Math.abs(d6) > 1.0E-9) {
                    System.out.println("dE=" + d6 + ", EnergyTotal=" + this.getTotalEnergy() + ", WorkApplied=" + this.getAppliedWork());
                }
                if (Math.abs(d3 = this.getBlock().getKineticEnergy() - this.getTotalWork()) > 1.0E-9) {
                    System.out.println("dK=" + d3 + ", Delta KE=" + this.getBlock().getKineticEnergy() + ", Net Work=" + this.getTotalWork());
                }
            }
            if (this.block.getKineticEnergy() != this.lastState.getKineticEnergy()) {
                this.keObservers.notifyObservers();
            }
            if (this.getPotentialEnergy() != this.lastState.getPotentialEnergy()) {
                this.peObservers.notifyObservers();
            }
        }
        this.lastTick = this.currentTimeSeconds();
        this.lastState = this.getState();
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.stepFinished();
        }
    }

    private double getKineticEnergy() {
        return this.getBlock().getKineticEnergy();
    }

    private double getAppliedWorkDifferential(RampPhysicalModel rampPhysicalModel) {
        double d = this.getBlockPosition() - rampPhysicalModel.getBlockPosition();
        double d2 = this.getAppliedForce().getParallelComponent() * d;
        double d3 = rampPhysicalModel.getPotentialEnergy() - this.lastState.getPotentialEnergy();
        double d4 = d2 + d3;
        return d4;
    }

    public void setupForces() {
        this.gravityForce.setX(0.0);
        this.gravityForce.setY(this.gravity * this.block.getMass());
        double d = this.block.getFrictionForce(this.gravity, this.appliedForce.getParallelComponent() + this.gravityForce.getParallelComponent());
        this.frictionForce.setParallel(d);
        double d2 = this.appliedForce.getParallelComponent() + this.gravityForce.getParallelComponent() + this.frictionForce.getParallelComponent();
        this.normalForce.setPerpendicular(this.gravityForce.getPerpendicularComponent());
        double d3 = this.getSurface().getWallForce(d2, this.getBlock());
        this.wallForce.setParallel(d3);
        this.totalForce.setParallel(d2 += d3);
        this.updateAppliedForceValue();
    }

    public void setWallForce(double d) {
        this.wallForce.setParallel(d);
    }

    private double getBlockPosition() {
        return this.getBlock().getPosition();
    }

    public void setUserIsAddingEnergy(boolean bl) {
        this.userAddingEnergy = bl;
    }

    public double getPotentialEnergy() {
        double d = this.getBlockHeight();
        return this.block.getMass() * d * this.gravity;
    }

    private double getBlockHeight() {
        return this.block.getLocation2D().getY() - this.zeroPointY;
    }

    public void setAppliedForce(double d) {
        this.appliedForceSetValue = d;
        this.appliedForce.setParallel(d);
        this.notifyAppliedForceChanged();
    }

    private void notifyAppliedForceChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.appliedForceChanged();
        }
    }

    public ForceVector getWallForce() {
        return this.wallForce;
    }

    public ForceVector getAppliedForce() {
        return this.appliedForce;
    }

    public ForceVector getGravityForce() {
        return this.gravityForce;
    }

    public ForceVector getTotalForce() {
        return this.totalForce;
    }

    public ForceVector getFrictionForce() {
        return this.frictionForce;
    }

    public ForceVector getNormalForce() {
        return this.normalForce;
    }

    public void reset() {
        this.block.setSurface(this.ramp);
        this.block.setPositionInSurface(10.0);
        this.block.setAcceleration(0.0);
        this.block.setVelocity(0.0);
        this.ramp.setAngle(0.17453292519943295);
        this.appliedWork = 0.0;
        this.frictiveWork = 0.0;
        this.gravityWork = 0.0;
        this.thermalEnergy = 0.0;
        this.peObservers.notifyObservers();
        this.keObservers.notifyObservers();
        this.lastState = this.getState();
        this.appliedForceSetValue = 0.0;
        this.setupForces();
        this.initWorks();
    }

    public void initWorks() {
        this.gravityWork = -this.getPotentialEnergy();
        this.appliedWork = -this.gravityWork + this.getKineticEnergy();
    }

    public double getFrictiveWork() {
        return this.frictiveWork;
    }

    public double getGravityWork() {
        return this.gravityWork;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setZeroPointY(double d) {
        this.zeroPointY = d;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.zeroPointChanged();
        }
        this.peObservers.notifyObservers();
    }

    public double getZeroPointY() {
        return this.zeroPointY;
    }

    public double getThermalEnergy() {
        return this.thermalEnergy;
    }

    public double getTotalEnergy() {
        return this.getPotentialEnergy() + this.getBlock().getKineticEnergy() + this.getThermalEnergy();
    }

    public Surface getGround() {
        return this.ground;
    }

    private Surface getSurface() {
        return this.block.getSurface();
    }

    public void setMass(double d) {
        this.block.setMass(d);
    }

    public void setObject(RampObject rampObject) {
        this.getBlock().setMass(rampObject.getMass());
        this.getBlock().setStaticFriction(rampObject.getStaticFriction());
        this.getBlock().setKineticFriction(rampObject.getKineticFriction());
    }

    public void collided(Surface surface) {
        if (this.block.isFrictionless()) {
            double d = Math.abs(this.block.getKineticEnergy() - this.originalBlockKE);
            this.thermalEnergy += d;
            this.frictiveWork -= d;
        }
    }

    public void clearHeat() {
        this.thermalEnergy = 0.0;
        this.frictiveWork = 0.0;
        this.initWorks();
    }

    public double getRampAngle() {
        return this.getRamp().getAngle();
    }

    public void setRampAngle(double d) {
        this.getRamp().setAngle(d);
    }

    public double getGlobalMaxPosition() {
        return this.getGround().getLength() + this.getRamp().getLength();
    }

    public double getGlobalMinPosition() {
        return 0.0;
    }

    public double getGlobalBlockPosition() {
        return this.block.getPosition();
    }

    public void setGlobalBlockPosition(double d) {
        if (d <= this.getGround().getLength()) {
            this.block.setSurface(this.getGround());
            this.block.setPositionInSurface(d);
        } else {
            this.block.setSurface(this.getRamp());
            this.block.setPositionInSurface(d - this.getGround().getLength());
        }
    }

    public double getAppliedForceScalar() {
        return this.appliedForceSetValue;
    }

    public double getParallelFrictionForce() {
        return this.frictionForce.getParallelComponent();
    }

    public double getParallelAppliedForce() {
        return this.appliedForce.getParallelComponent();
    }

    public double getParallelWeightForce() {
        return this.gravityForce.getParallelComponent();
    }

    public double getParallelWallForce() {
        return this.wallForce.getParallelComponent();
    }

    public Surface getSurfaceGraphic(double d) {
        if (d <= this.ground.getLength()) {
            return this.ground;
        }
        return this.ramp;
    }

    public double getAppliedWork() {
        return this.appliedWork;
    }

    public RampPhysicalModel getState() {
        RampPhysicalModel rampPhysicalModel = new RampPhysicalModel();
        rampPhysicalModel.ramp = this.ramp.copyState();
        rampPhysicalModel.ground = this.ground.copyState();
        rampPhysicalModel.block = this.block.copyState(this, rampPhysicalModel);
        rampPhysicalModel.wallForce = this.wallForce.copyState();
        rampPhysicalModel.appliedForce = this.appliedForce.copyState();
        rampPhysicalModel.gravityForce = this.gravityForce.copyState();
        rampPhysicalModel.totalForce = this.totalForce.copyState();
        rampPhysicalModel.frictionForce = this.frictionForce.copyState();
        rampPhysicalModel.normalForce = this.normalForce.copyState();
        rampPhysicalModel.gravity = this.gravity;
        rampPhysicalModel.appliedWork = this.appliedWork;
        rampPhysicalModel.frictiveWork = this.frictiveWork;
        rampPhysicalModel.gravityWork = this.gravityWork;
        rampPhysicalModel.zeroPointY = this.zeroPointY;
        rampPhysicalModel.thermalEnergy = this.thermalEnergy;
        rampPhysicalModel.appliedForceSetValue = this.appliedForceSetValue;
        return rampPhysicalModel;
    }

    public void setState(RampPhysicalModel rampPhysicalModel) {
        this.ramp.setState(rampPhysicalModel.getRamp());
        this.block.setState(rampPhysicalModel.getBlock());
        this.wallForce.setState(rampPhysicalModel.wallForce);
        this.appliedForce.setState(rampPhysicalModel.appliedForce);
        this.gravityForce.setState(rampPhysicalModel.gravityForce);
        this.totalForce.setState(rampPhysicalModel.totalForce);
        this.frictionForce.setState(rampPhysicalModel.frictionForce);
        this.normalForce.setState(rampPhysicalModel.normalForce);
        this.gravity = rampPhysicalModel.gravity;
        this.appliedWork = rampPhysicalModel.appliedWork;
        this.frictiveWork = rampPhysicalModel.frictiveWork;
        this.gravityWork = rampPhysicalModel.gravityWork;
        this.zeroPointY = rampPhysicalModel.zeroPointY;
        this.thermalEnergy = rampPhysicalModel.thermalEnergy;
        this.appliedForceSetValue = rampPhysicalModel.appliedForceSetValue;
    }

    public double getTotalWork() {
        return this.getGravityWork() + this.getFrictiveWork() + this.getAppliedWork();
    }

    public static class Adapter
    implements Listener {
        public void appliedForceChanged() {
        }

        public void zeroPointChanged() {
        }

        public void stepFinished() {
        }
    }

    public class ForceVector
    extends MutableVector2D {
        public void setParallel(double d) {
            this.setX(Math.cos(-RampPhysicalModel.this.getSurface().getAngle()) * d);
            this.setY(Math.sin(-RampPhysicalModel.this.getSurface().getAngle()) * d);
        }

        public double getParallelComponent() {
            Vector2D vector2D = MutableVector2D.createPolar(1.0, -RampPhysicalModel.this.getSurface().getAngle());
            return vector2D.dot(this);
        }

        public double getPerpendicularComponent() {
            Vector2D vector2D = MutableVector2D.createPolar(1.0, -RampPhysicalModel.this.getSurface().getAngle());
            vector2D = vector2D.getPerpendicularVector();
            return vector2D.dot(this);
        }

        public void setPerpendicular(double d) {
            this.setX(Math.sin(RampPhysicalModel.this.getSurface().getAngle()) * d);
            this.setY(Math.cos(RampPhysicalModel.this.getSurface().getAngle()) * d);
        }

        public MutableVector2D toParallelVector() {
            ForceVector forceVector = new ForceVector();
            forceVector.setParallel(this.getParallelComponent());
            return forceVector;
        }

        public MutableVector2D toPerpendicularVector() {
            ForceVector forceVector = new ForceVector();
            forceVector.setPerpendicular(-this.getPerpendicularComponent());
            return forceVector;
        }

        public MutableVector2D toXVector() {
            return new MutableVector2D(this.getX(), 0.0);
        }

        public MutableVector2D toYVector() {
            return new MutableVector2D(0.0, this.getY());
        }

        public ForceVector copyState() {
            ForceVector forceVector = new ForceVector();
            forceVector.setX(this.getX());
            forceVector.setY(this.getY());
            return forceVector;
        }

        public void setState(ForceVector forceVector) {
            this.setX(forceVector.getX());
            this.setY(forceVector.getY());
        }
    }

    public static interface Listener {
        public void appliedForceChanged();

        public void zeroPointChanged();

        public void stepFinished();
    }

    public class NewStepCode
    implements ModelElement {
        public void stepInTime(double d) {
            RampPhysicalModel.this.newStepCode(d);
        }
    }
}

