/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp.model;

import edu.colorado.phet.theramp.model.Collision;
import edu.colorado.phet.theramp.model.Ramp;
import edu.colorado.phet.theramp.model.RampPhysicalModel;
import edu.colorado.phet.theramp.model.Surface;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Block {
    private Surface surface;
    private double mass = 5.0;
    private double positionInSurface = 10.0;
    private double velocity = 0.0;
    private double acceleration = 0.0;
    private double kineticFriction = 0.5;
    private double staticFriction = 0.8;
    private ArrayList listeners = new ArrayList();
    private boolean justCollided = false;

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public Block copyState(RampPhysicalModel rampPhysicalModel, RampPhysicalModel rampPhysicalModel2) {
        Block block = new Block(this.surface instanceof Ramp ? rampPhysicalModel2.getRamp() : rampPhysicalModel2.getGround());
        block.mass = this.mass;
        block.positionInSurface = this.positionInSurface;
        block.velocity = this.velocity;
        block.acceleration = this.acceleration;
        block.kineticFriction = this.kineticFriction;
        block.staticFriction = this.staticFriction;
        block.testRampOnly();
        return block;
    }

    private void testRampOnly() {
    }

    public void setState(Block block) {
        this.setSurface(block.getSurface());
        this.setMass(block.mass);
        this.setPositionInSurface(block.positionInSurface);
        this.setVelocity(block.velocity);
        this.setAcceleration(block.acceleration);
        this.setKineticFriction(block.kineticFriction);
        this.setStaticFriction(block.staticFriction);
        this.testRampOnly();
    }

    public void setSurface(Surface surface) {
        if (this.surface != surface) {
            this.surface = surface;
            this.notifySurfaceChanged();
        }
        this.testRampOnly();
    }

    private void notifySurfaceChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.surfaceChanged();
        }
    }

    public Surface getSurface() {
        return this.surface;
    }

    public double getMomentum() {
        return this.mass * this.velocity;
    }

    public Block(Surface surface) {
        this.surface = surface;
        this.testRampOnly();
    }

    public double getPosition() {
        return this.getPositionInSurface() + this.getSurface().getDistanceOffset();
    }

    public double getPositionInSurface() {
        return this.positionInSurface;
    }

    public Point2D getLocation2D() {
        return this.surface.getLocation(this.positionInSurface);
    }

    public void setPositionInSurface(double d) {
        this.positionInSurface = d;
        this.notifyPositionChanged();
    }

    private void notifyPositionChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.positionChanged();
        }
    }

    public double getMass() {
        return this.mass;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setAcceleration(double d) {
        this.acceleration = d;
    }

    public void stepInTime(RampPhysicalModel rampPhysicalModel, double d) {
        Block block = this.copyState(rampPhysicalModel, rampPhysicalModel);
        double d2 = this.positionInSurface;
        double d3 = this.velocity;
        double d4 = this.acceleration;
        if (Math.abs(d4) < 1.0E-7) {
            d4 = 0.0;
        }
        this.velocity += d4 * d;
        boolean bl = this.changedSign(d3, this.velocity);
        if (bl) {
            this.velocity = 0.0;
        }
        this.positionInSurface += this.velocity * d;
        this.applyBoundaryConditions(block, rampPhysicalModel, d);
        if (this.positionInSurface != d2) {
            this.notifyPositionChanged();
        }
        if (this.velocity != d3) {
            this.notifyVelocityChanged();
        }
    }

    private void notifyVelocityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.velocityChanged();
        }
    }

    private void applyBoundaryConditions(Block block, RampPhysicalModel rampPhysicalModel, double d) {
        this.justCollided = false;
        boolean bl = this.surface.applyBoundaryConditions(rampPhysicalModel, this);
        if (bl) {
            Collision collision = new Collision(block, this, rampPhysicalModel, d);
            this.notifyCollision(collision);
            this.justCollided = true;
        }
    }

    public boolean isJustCollided() {
        return this.justCollided;
    }

    private void notifyCollision(Collision collision) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.collisionOccurred(collision);
        }
    }

    public double getKineticEnergy() {
        return 0.5 * this.getMass() * this.getVelocity() * this.getVelocity();
    }

    public void setVelocity(double d) {
        this.velocity = d;
    }

    public void setMass(double d) {
        this.mass = d;
        this.notifyMassChanged();
    }

    private void notifyMassChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.massChanged();
        }
    }

    public void setStaticFriction(double d) {
        if (this.staticFriction != d) {
            this.staticFriction = d;
            this.notifyStaticFrictionChanged();
        }
    }

    private void notifyStaticFrictionChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.staticFrictionChanged();
        }
    }

    public void setKineticFriction(double d) {
        if (this.kineticFriction != d) {
            this.kineticFriction = d;
            this.notifyKineticFrictionChanged();
        }
    }

    private void notifyKineticFrictionChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.kineticFrictionChanged();
        }
    }

    private boolean changedSign(double d, double d2) {
        Sign sign = Sign.toSign(d);
        Sign sign2 = Sign.toSign(d2);
        boolean bl = sign.equals(Sign.POSITIVE) && sign2.equals(Sign.NEGATIVE);
        boolean bl2 = sign.equals(Sign.NEGATIVE) && sign2.equals(Sign.POSITIVE);
        boolean bl3 = bl || bl2;
        return bl3;
    }

    public double getFrictionForce(double d, double d2) {
        double d3 = this.getMass() * d * Math.cos(this.surface.getAngle());
        if (this.isMoving()) {
            double d4 = this.getVelocity() >= 0.0 ? -1.0 : 1.0;
            double d5 = d4 * this.getKineticFriction() * d3;
            return d5;
        }
        double d6 = Math.max(this.getKineticFriction(), this.getStaticFriction());
        double d7 = d6 * d3;
        if (Math.abs(d7) > Math.abs(d2)) {
            return -d2;
        }
        double d8 = d2 >= 0.0 ? -1.0 : 1.0;
        double d9 = d8 * d6 * d3;
        return d9;
    }

    public double getStaticFriction() {
        return this.staticFriction;
    }

    public double getKineticFriction() {
        return this.kineticFriction;
    }

    public boolean isFrictionless() {
        return this.staticFriction == 0.0 && this.kineticFriction == 0.0;
    }

    private boolean isMoving() {
        return this.velocity != 0.0;
    }

    public static class Adapter
    implements Listener {
        public void positionChanged() {
        }

        public void staticFrictionChanged() {
        }

        public void kineticFrictionChanged() {
        }

        public void massChanged() {
        }

        public void surfaceChanged() {
        }

        public void collisionOccurred(Collision collision) {
        }

        public void velocityChanged() {
        }
    }

    public static interface Listener {
        public void positionChanged();

        public void staticFrictionChanged();

        public void kineticFrictionChanged();

        public void massChanged();

        public void surfaceChanged();

        public void collisionOccurred(Collision var1);

        public void velocityChanged();
    }

    static class Sign {
        static final Sign POSITIVE = new Sign("+");
        static final Sign NEGATIVE = new Sign("-");
        static final Sign ZERO = new Sign("0");
        private String s;

        public static Sign toSign(double d) {
            if (d > 0.0) {
                return POSITIVE;
            }
            if (d < 0.0) {
                return NEGATIVE;
            }
            return ZERO;
        }

        public Sign(String string) {
            this.s = string;
        }

        public boolean equals(Object object) {
            return object instanceof Sign && ((Sign)object).s.equals(this.s);
        }
    }
}

