/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.theramp;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.theramp.RampModule;
import edu.colorado.phet.theramp.TheRampStrings;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RampAngleController {
    private RampModule rampModule;
    private ModelSlider modelSlider;

    public RampAngleController(final RampModule rampModule) {
        this.rampModule = rampModule;
        this.modelSlider = new ModelSlider(TheRampStrings.getString("property.ramp-angle"), TheRampStrings.getString("units.degrees"), 0.0, 90.0, rampModule.getRampAngle());
        rampModule.getRampPhysicalModel().getRamp().addObserver(new SimpleObserver(){

            public void update() {
                double d = rampModule.getRampAngle() / 2.0 / Math.PI * 360.0;
                RampAngleController.this.modelSlider.setValue(d);
            }
        });
        this.modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = RampAngleController.this.modelSlider.getValue();
                rampModule.getRampPhysicalModel().getRamp().setAngle(d * Math.PI * 2.0 / 360.0);
            }
        });
        this.modelSlider.setModelTicks(new double[]{0.0, 30.0, 60.0, 90.0});
    }

    public JComponent getComponent() {
        return this.modelSlider;
    }
}

