/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Web
extends TestbedTest {
    Body[] m_bodies = new Body[4];
    Joint[] m_joints = new Joint[8];

    public void initTest() {
        Body body = null;
        Object object = new BodyDef();
        body = this.m_world.createBody((BodyDef)object);
        Object object2 = new PolygonShape();
        ((PolygonShape)object2).setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture((Shape)object2, 0.0f);
        object = new PolygonShape();
        ((PolygonShape)object).setAsBox(0.5f, 0.5f);
        object2 = new BodyDef();
        ((BodyDef)object2).type = BodyType.DYNAMIC;
        ((BodyDef)object2).position.set(-5.0f, 5.0f);
        this.m_bodies[0] = this.m_world.createBody((BodyDef)object2);
        this.m_bodies[0].createFixture((Shape)object, 5.0f);
        ((BodyDef)object2).position.set(5.0f, 5.0f);
        this.m_bodies[1] = this.m_world.createBody((BodyDef)object2);
        this.m_bodies[1].createFixture((Shape)object, 5.0f);
        ((BodyDef)object2).position.set(5.0f, 15.0f);
        this.m_bodies[2] = this.m_world.createBody((BodyDef)object2);
        this.m_bodies[2].createFixture((Shape)object, 5.0f);
        ((BodyDef)object2).position.set(-5.0f, 15.0f);
        this.m_bodies[3] = this.m_world.createBody((BodyDef)object2);
        this.m_bodies[3].createFixture((Shape)object, 5.0f);
        DistanceJointDef distanceJointDef = new DistanceJointDef();
        Vec2 vec2 = new Vec2();
        Vec2 vec22 = new Vec2();
        Vec2 vec23 = new Vec2();
        distanceJointDef.frequencyHz = 4.0f;
        distanceJointDef.dampingRatio = 0.5f;
        distanceJointDef.bodyA = body;
        distanceJointDef.bodyB = this.m_bodies[0];
        distanceJointDef.localAnchorA.set(-10.0f, 0.0f);
        distanceJointDef.localAnchorB.set(-0.5f, -0.5f);
        vec2 = distanceJointDef.bodyA.getWorldPoint(distanceJointDef.localAnchorA);
        vec22 = distanceJointDef.bodyB.getWorldPoint(distanceJointDef.localAnchorB);
        vec23 = vec22.sub(vec2);
        distanceJointDef.length = vec23.length();
        this.m_joints[0] = this.m_world.createJoint(distanceJointDef);
        distanceJointDef.bodyA = body;
        distanceJointDef.bodyB = this.m_bodies[1];
        distanceJointDef.localAnchorA.set(10.0f, 0.0f);
        distanceJointDef.localAnchorB.set(0.5f, -0.5f);
        vec2 = distanceJointDef.bodyA.getWorldPoint(distanceJointDef.localAnchorA);
        vec22 = distanceJointDef.bodyB.getWorldPoint(distanceJointDef.localAnchorB);
        vec23 = vec22.sub(vec2);
        distanceJointDef.length = vec23.length();
        this.m_joints[1] = this.m_world.createJoint(distanceJointDef);
        distanceJointDef.bodyA = body;
        distanceJointDef.bodyB = this.m_bodies[2];
        distanceJointDef.localAnchorA.set(10.0f, 20.0f);
        distanceJointDef.localAnchorB.set(0.5f, 0.5f);
        vec2 = distanceJointDef.bodyA.getWorldPoint(distanceJointDef.localAnchorA);
        vec22 = distanceJointDef.bodyB.getWorldPoint(distanceJointDef.localAnchorB);
        vec23 = vec22.sub(vec2);
        distanceJointDef.length = vec23.length();
        this.m_joints[2] = this.m_world.createJoint(distanceJointDef);
        distanceJointDef.bodyA = body;
        distanceJointDef.bodyB = this.m_bodies[3];
        distanceJointDef.localAnchorA.set(-10.0f, 20.0f);
        distanceJointDef.localAnchorB.set(-0.5f, 0.5f);
        vec2 = distanceJointDef.bodyA.getWorldPoint(distanceJointDef.localAnchorA);
        vec22 = distanceJointDef.bodyB.getWorldPoint(distanceJointDef.localAnchorB);
        vec23 = vec22.sub(vec2);
        distanceJointDef.length = vec23.length();
        this.m_joints[3] = this.m_world.createJoint(distanceJointDef);
        distanceJointDef.bodyA = this.m_bodies[0];
        distanceJointDef.bodyB = this.m_bodies[1];
        distanceJointDef.localAnchorA.set(0.5f, 0.0f);
        distanceJointDef.localAnchorB.set(-0.5f, 0.0f);
        vec2 = distanceJointDef.bodyA.getWorldPoint(distanceJointDef.localAnchorA);
        vec22 = distanceJointDef.bodyB.getWorldPoint(distanceJointDef.localAnchorB);
        vec23 = vec22.sub(vec2);
        distanceJointDef.length = vec23.length();
        this.m_joints[4] = this.m_world.createJoint(distanceJointDef);
        distanceJointDef.bodyA = this.m_bodies[1];
        distanceJointDef.bodyB = this.m_bodies[2];
        distanceJointDef.localAnchorA.set(0.0f, 0.5f);
        distanceJointDef.localAnchorB.set(0.0f, -0.5f);
        vec2 = distanceJointDef.bodyA.getWorldPoint(distanceJointDef.localAnchorA);
        vec22 = distanceJointDef.bodyB.getWorldPoint(distanceJointDef.localAnchorB);
        vec23 = vec22.sub(vec2);
        distanceJointDef.length = vec23.length();
        this.m_joints[5] = this.m_world.createJoint(distanceJointDef);
        distanceJointDef.bodyA = this.m_bodies[2];
        distanceJointDef.bodyB = this.m_bodies[3];
        distanceJointDef.localAnchorA.set(-0.5f, 0.0f);
        distanceJointDef.localAnchorB.set(0.5f, 0.0f);
        vec2 = distanceJointDef.bodyA.getWorldPoint(distanceJointDef.localAnchorA);
        vec22 = distanceJointDef.bodyB.getWorldPoint(distanceJointDef.localAnchorB);
        vec23 = vec22.sub(vec2);
        distanceJointDef.length = vec23.length();
        this.m_joints[6] = this.m_world.createJoint(distanceJointDef);
        distanceJointDef.bodyA = this.m_bodies[3];
        distanceJointDef.bodyB = this.m_bodies[0];
        distanceJointDef.localAnchorA.set(0.0f, -0.5f);
        distanceJointDef.localAnchorB.set(0.0f, 0.5f);
        vec2 = distanceJointDef.bodyA.getWorldPoint(distanceJointDef.localAnchorA);
        vec22 = distanceJointDef.bodyB.getWorldPoint(distanceJointDef.localAnchorB);
        vec23 = vec22.sub(vec2);
        distanceJointDef.length = vec23.length();
        this.m_joints[7] = this.m_world.createJoint(distanceJointDef);
    }

    public void keyPressed(char c, int n) {
        block0 : switch (c) {
            case 'b': {
                for (int i = 0; i < 4; ++i) {
                    if (this.m_bodies[i] == null) continue;
                    this.m_world.destroyBody(this.m_bodies[i]);
                    this.m_bodies[i] = null;
                    break block0;
                }
                break;
            }
            case 'j': {
                for (int i = 0; i < 8; ++i) {
                    if (this.m_joints[i] == null) continue;
                    this.m_world.destroyJoint(this.m_joints[i]);
                    this.m_joints[i] = null;
                    break block0;
                }
                break;
            }
        }
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("This demonstrates a soft distance joint.");
        this.addTextLine("Press: (b) to delete a body, (j) to delete a joint");
    }

    public void jointDestroyed(Joint joint) {
        for (int i = 0; i < 8; ++i) {
            if (this.m_joints[i] != joint) continue;
            this.m_joints[i] = null;
            break;
        }
    }

    public String getTestName() {
        return "Web";
    }
}

