/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class SensorTest
extends TestbedTest {
    int e_count = 7;
    Fixture m_sensor;
    Body[] m_bodies = new Body[this.e_count];
    BoolWrapper[] m_touching = new BoolWrapper[this.e_count];

    public void initTest() {
        for (int i = 0; i < this.m_touching.length; ++i) {
            this.m_touching[i] = new BoolWrapper();
        }
        Object object = new BodyDef();
        Body body = this.m_world.createBody((BodyDef)object);
        Object object2 = new PolygonShape();
        ((PolygonShape)object2).setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture((Shape)object2, 0.0f);
        object2 = new CircleShape();
        ((CircleShape)object2).m_radius = 5.0f;
        ((CircleShape)object2).m_p.set(0.0f, 10.0f);
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = object2;
        fixtureDef.isSensor = true;
        this.m_sensor = body.createFixture(fixtureDef);
        object = new CircleShape();
        ((CircleShape)object).m_radius = 1.0f;
        for (int i = 0; i < this.e_count; ++i) {
            object2 = new BodyDef();
            ((BodyDef)object2).type = BodyType.DYNAMIC;
            ((BodyDef)object2).position.set(-10.0f + 3.0f * (float)i, 20.0f);
            ((BodyDef)object2).userData = this.m_touching[i];
            this.m_touching[i].tf = false;
            this.m_bodies[i] = this.m_world.createBody((BodyDef)object2);
            this.m_bodies[i].createFixture((Shape)object, 1.0f);
        }
    }

    public void beginContact(Contact contact) {
        Object object;
        Fixture fixture = contact.getFixtureA();
        Fixture fixture2 = contact.getFixtureB();
        if (fixture == this.m_sensor && (object = fixture2.getBody().getUserData()) != null) {
            ((BoolWrapper)object).tf = true;
        }
        if (fixture2 == this.m_sensor && (object = fixture.getBody().getUserData()) != null) {
            ((BoolWrapper)object).tf = true;
        }
    }

    public void endContact(Contact contact) {
        Object object;
        Fixture fixture = contact.getFixtureA();
        Fixture fixture2 = contact.getFixtureB();
        if (fixture == this.m_sensor && (object = fixture2.getBody().getUserData()) != null) {
            ((BoolWrapper)object).tf = false;
        }
        if (fixture2 == this.m_sensor && (object = fixture.getBody().getUserData()) != null) {
            ((BoolWrapper)object).tf = false;
        }
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        for (int i = 0; i < this.e_count; ++i) {
            Vec2 vec2;
            if (!this.m_touching[i].tf) continue;
            Body body = this.m_bodies[i];
            Body body2 = this.m_sensor.getBody();
            CircleShape circleShape = (CircleShape)this.m_sensor.getShape();
            Vec2 vec22 = body2.getWorldPoint(circleShape.m_p);
            Vec2 vec23 = vec22.sub(vec2 = body.getPosition());
            if (vec23.lengthSquared() < 1.4210855E-14f) continue;
            vec23.normalize();
            Vec2 vec24 = vec23.mulLocal(100.0f);
            body.applyForce(vec24, vec2);
        }
    }

    public String getTestName() {
        return "Sensor Test";
    }

    class BoolWrapper {
        boolean tf;

        BoolWrapper() {
        }
    }
}

