/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Distance;
import org.jbox2d.collision.DistanceInput;
import org.jbox2d.collision.DistanceOutput;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class DistanceTest
extends TestbedTest {
    Vec2 m_positionB;
    float m_angleB;
    Transform m_transformA;
    Transform m_transformB;
    PolygonShape m_polygonA;
    PolygonShape m_polygonB;
    DistanceInput input = new DistanceInput();
    Distance.SimplexCache cache = new Distance.SimplexCache();
    DistanceOutput output = new DistanceOutput();
    Color3f color = new Color3f(0.9f, 0.9f, 0.9f);
    Vec2[] v = new Vec2[Settings.maxPolygonVertices];
    Color3f c1 = new Color3f(1.0f, 0.0f, 0.0f);
    Color3f c2 = new Color3f(1.0f, 1.0f, 0.0f);

    public String getTestName() {
        return "Distance";
    }

    public void initTest() {
        this.input.transformA = new Transform();
        this.input.transformB = new Transform();
        this.m_transformA = new Transform();
        this.m_transformA.setIdentity();
        this.m_transformA.position.set(0.0f, -0.2f);
        this.m_polygonA = new PolygonShape();
        this.m_polygonA.setAsBox(10.0f, 0.2f);
        this.m_positionB = new Vec2();
        this.m_positionB.set(12.017401f, 0.13678508f);
        this.m_angleB = -0.0109265f;
        this.m_transformB = new Transform();
        this.m_transformB.set(this.m_positionB, this.m_angleB);
        this.m_polygonB = new PolygonShape();
        this.m_polygonB.setAsBox(2.0f, 0.1f);
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = new Vec2();
        }
    }

    public void step(TestbedSettings testbedSettings) {
        int n;
        super.step(testbedSettings);
        this.input.proxyA.set(this.m_polygonA);
        this.input.proxyB.set(this.m_polygonB);
        this.input.transformA.set(this.m_transformA);
        this.input.transformB.set(this.m_transformB);
        this.input.useRadii = true;
        this.cache.count = 0;
        this.m_world.getPool().getDistance().distance(this.output, this.cache, this.input);
        this.addTextLine("distance = " + this.output.distance);
        this.addTextLine("iterations = " + this.output.iterations);
        for (n = 0; n < this.m_polygonA.m_vertexCount; ++n) {
            Transform.mulToOut(this.m_transformA, this.m_polygonA.m_vertices[n], this.v[n]);
        }
        this.m_debugDraw.drawPolygon(this.v, this.m_polygonA.m_vertexCount, this.color);
        for (n = 0; n < this.m_polygonB.m_vertexCount; ++n) {
            Transform.mulToOut(this.m_transformB, this.m_polygonB.m_vertices[n], this.v[n]);
        }
        this.m_debugDraw.drawPolygon(this.v, this.m_polygonB.m_vertexCount, this.color);
        Vec2 vec2 = this.output.pointA;
        Vec2 vec22 = this.output.pointB;
        this.m_debugDraw.drawPoint(vec2, 4.0f, this.c1);
        this.m_debugDraw.drawPoint(vec22, 4.0f, this.c2);
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'a': {
                this.m_positionB.x -= 0.1f;
                break;
            }
            case 'd': {
                this.m_positionB.x += 0.1f;
                break;
            }
            case 's': {
                this.m_positionB.y -= 0.1f;
                break;
            }
            case 'w': {
                this.m_positionB.y += 0.1f;
                break;
            }
            case 'q': {
                this.m_angleB += 0.31415927f;
                break;
            }
            case 'e': {
                this.m_angleB -= 0.31415927f;
            }
        }
        this.m_transformB.set(this.m_positionB, this.m_angleB);
    }
}

