/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Breakable
extends TestbedTest {
    Body m_body1;
    Vec2 m_velocity;
    float m_angularVelocity;
    PolygonShape m_shape1;
    PolygonShape m_shape2;
    Fixture m_piece1;
    Fixture m_piece2;
    boolean m_broke;
    boolean m_break;

    public void initTest() {
        BodyDef bodyDef = new BodyDef();
        Body body = this.m_world.createBody(bodyDef);
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture(polygonShape, 0.0f);
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 40.0f);
        bodyDef.angle = 0.7853982f;
        this.m_body1 = this.m_world.createBody(bodyDef);
        this.m_shape1 = new PolygonShape();
        this.m_shape1.setAsBox(0.5f, 0.5f, new Vec2(-0.5f, 0.0f), 0.0f);
        this.m_piece1 = this.m_body1.createFixture(this.m_shape1, 1.0f);
        this.m_shape2 = new PolygonShape();
        this.m_shape2.setAsBox(0.5f, 0.5f, new Vec2(0.5f, 0.0f), 0.0f);
        this.m_piece2 = this.m_body1.createFixture(this.m_shape2, 1.0f);
        this.m_break = false;
        this.m_broke = false;
    }

    public void postSolve(Contact contact, ContactImpulse contactImpulse) {
        if (this.m_broke) {
            return;
        }
        int n = contact.getManifold().pointCount;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f = MathUtils.max(f, contactImpulse.normalImpulses[i]);
        }
        if (f > 40.0f) {
            this.m_break = true;
        }
    }

    void Break() {
        Body body = this.m_piece1.getBody();
        Vec2 vec2 = body.getWorldCenter();
        body.destroyFixture(this.m_piece2);
        this.m_piece2 = null;
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position = body.getPosition();
        bodyDef.angle = body.getAngle();
        Body body2 = this.m_world.createBody(bodyDef);
        this.m_piece2 = body2.createFixture(this.m_shape2, 1.0f);
        Vec2 vec22 = body.getWorldCenter();
        Vec2 vec23 = body2.getWorldCenter();
        Vec2 vec24 = this.m_velocity.add(Vec2.cross(this.m_angularVelocity, vec22.sub(vec2)));
        Vec2 vec25 = this.m_velocity.add(Vec2.cross(this.m_angularVelocity, vec23.sub(vec2)));
        body.setAngularVelocity(this.m_angularVelocity);
        body.setLinearVelocity(vec24);
        body2.setAngularVelocity(this.m_angularVelocity);
        body2.setLinearVelocity(vec25);
    }

    public void step(TestbedSettings testbedSettings) {
        if (this.m_break) {
            this.Break();
            this.m_broke = true;
            this.m_break = false;
        }
        if (!this.m_broke) {
            this.m_velocity = this.m_body1.getLinearVelocity();
            this.m_angularVelocity = this.m_body1.getAngularVelocity();
        }
        super.step(testbedSettings);
    }

    public String getTestName() {
        return "Breakable";
    }
}

