/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.FrictionJointDef;
import org.jbox2d.testbed.framework.TestPanel;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ApplyForce
extends TestbedTest {
    Body m_body;

    public void initTest() {
        this.m_world.setGravity(new Vec2(0.0f, 0.0f));
        Object object = new BodyDef();
        ((BodyDef)object).position.set(0.0f, 20.0f);
        Body body = this.m_world.createBody((BodyDef)object);
        Object object2 = new PolygonShape();
        Object object3 = new FixtureDef();
        ((FixtureDef)object3).shape = object2;
        ((FixtureDef)object3).density = 0.0f;
        ((FixtureDef)object3).restitution = 0.4f;
        object2.setAsEdge(new Vec2(-20.0f, -20.0f), new Vec2(-20.0f, 20.0f));
        body.createFixture((FixtureDef)object3);
        object2.setAsEdge(new Vec2(20.0f, -20.0f), new Vec2(20.0f, 20.0f));
        body.createFixture((FixtureDef)object3);
        object2.setAsEdge(new Vec2(-20.0f, 20.0f), new Vec2(20.0f, 20.0f));
        body.createFixture((FixtureDef)object3);
        object2.setAsEdge(new Vec2(-20.0f, -20.0f), new Vec2(20.0f, -20.0f));
        body.createFixture((FixtureDef)object3);
        object = new Transform();
        ((Transform)object).R.set(1.1070973f);
        Mat22.mulToOut(((Transform)object).R, new Vec2(1.0f, 0.0f), ((Transform)object).position);
        object2 = new Vec2[]{Transform.mul((Transform)object, new Vec2(-1.0f, 0.0f)), Transform.mul((Transform)object, new Vec2(1.0f, 0.0f)), Transform.mul((Transform)object, new Vec2(0.0f, 0.5f))};
        object3 = new PolygonShape();
        ((PolygonShape)object3).set((Vec2[])object2, 3);
        Object object4 = new FixtureDef();
        ((FixtureDef)object4).shape = object3;
        ((FixtureDef)object4).density = 4.0f;
        Object object5 = new Transform();
        ((Transform)object5).R.set(-1.1070973f);
        Mat22.mulToOut(((Transform)object5).R, new Vec2(-1.0f, 0.0f), ((Transform)object5).position);
        object2[0] = Transform.mul((Transform)object5, new Vec2(-1.0f, 0.0f));
        object2[1] = Transform.mul((Transform)object5, new Vec2(1.0f, 0.0f));
        object2[2] = Transform.mul((Transform)object5, new Vec2(0.0f, 0.5f));
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.set((Vec2[])object2, 3);
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = polygonShape;
        fixtureDef.density = 2.0f;
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.angularDamping = 5.0f;
        bodyDef.linearDamping = 0.1f;
        bodyDef.position.set(0.0f, 2.0f);
        bodyDef.angle = (float)Math.PI;
        bodyDef.allowSleep = false;
        this.m_body = this.m_world.createBody(bodyDef);
        this.m_body.createFixture((FixtureDef)object4);
        this.m_body.createFixture(fixtureDef);
        object = new PolygonShape();
        ((PolygonShape)object).setAsBox(0.5f, 0.5f);
        object2 = new FixtureDef();
        object2.shape = object;
        object2.density = 1.0f;
        object2.friction = 0.3f;
        for (int i = 0; i < 10; ++i) {
            object4 = new BodyDef();
            ((BodyDef)object4).type = BodyType.DYNAMIC;
            ((BodyDef)object4).position.set(0.0f, 5.0f + 1.54f * (float)i);
            object5 = this.m_world.createBody((BodyDef)object4);
            ((Body)object5).createFixture((FixtureDef)object2);
            float f = 10.0f;
            float f2 = ((Body)object5).getInertia();
            float f3 = ((Body)object5).getMass();
            float f4 = MathUtils.sqrt(2.0f * f2 / f3);
            FrictionJointDef frictionJointDef = new FrictionJointDef();
            frictionJointDef.localAnchorA.setZero();
            frictionJointDef.localAnchorB.setZero();
            frictionJointDef.bodyA = body;
            frictionJointDef.bodyB = object5;
            frictionJointDef.collideConnected = true;
            frictionJointDef.maxForce = f3 * f;
            frictionJointDef.maxTorque = f3 * f4 * f;
            this.m_world.createJoint(frictionJointDef);
        }
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Use 'wasd' to move, 'e' and 's' drift.");
        if (TestPanel.keys[119]) {
            Vec2 vec2 = this.m_body.getWorldVector(new Vec2(0.0f, -30.0f));
            Vec2 vec22 = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2(0.0f, 2.0f)));
            this.m_body.applyForce(vec2, vec22);
        } else if (TestPanel.keys[113]) {
            Vec2 vec2 = this.m_body.getWorldVector(new Vec2(0.0f, -30.0f));
            Vec2 vec23 = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2(-0.2f, 0.0f)));
            this.m_body.applyForce(vec2, vec23);
        } else if (TestPanel.keys[101]) {
            Vec2 vec2 = this.m_body.getWorldVector(new Vec2(0.0f, -30.0f));
            Vec2 vec24 = this.m_body.getWorldPoint(this.m_body.getLocalCenter().add(new Vec2(0.2f, 0.0f)));
            this.m_body.applyForce(vec2, vec24);
        } else if (TestPanel.keys[115]) {
            Vec2 vec2 = this.m_body.getWorldVector(new Vec2(0.0f, 30.0f));
            Vec2 vec25 = this.m_body.getWorldCenter();
            this.m_body.applyForce(vec2, vec25);
        }
        if (TestPanel.keys[97]) {
            this.m_body.applyTorque(20.0f);
        }
        if (TestPanel.keys[100]) {
            this.m_body.applyTorque(-20.0f);
        }
    }

    public String getTestName() {
        return "Apply Force";
    }
}

