/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.perf;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.WorldPool;
import org.jbox2d.testbed.perf.PerfTest;

public class PoolingPerf
extends PerfTest {
    public static final int INNER_ITERS = 1000000;
    public static final int OUTER_ITERS = 100;
    public String[] tests = new String[]{"Creation", "World Pool", "Circle Pool", "Custom Stack", "ThreadLocal member", "Member"};
    public float aStore = 0.0f;
    public IWorldPool wp = new WorldPool(100, 10);
    public CirclePool cp = new CirclePool();
    public TLVec2 tlv = new TLVec2();
    public Vec2 mv = new Vec2();
    public CustStack stack = new CustStack();

    public PoolingPerf() {
        super(6, 100);
    }

    public float op(Vec2 vec2) {
        vec2.set(MathUtils.randomFloat(-100.0f, 100.0f), MathUtils.randomFloat(-100.0f, 100.0f));
        vec2.mulLocal(3.2f);
        float f = vec2.length();
        vec2.normalize();
        return f;
    }

    public void runTest(int n) {
        switch (n) {
            case 0: {
                this.runCreationTest();
                break;
            }
            case 1: {
                this.runWorldPoolTest();
                break;
            }
            case 2: {
                this.runCirclePoolTest();
                break;
            }
            case 3: {
                this.runCustStackTest();
                break;
            }
            case 4: {
                this.runThreadLocalTest();
                break;
            }
            case 5: {
                this.runMemberTest();
            }
        }
    }

    public void runCreationTest() {
        float f = 0.0f;
        for (int i = 0; i < 1000000; ++i) {
            Vec2 vec2 = new Vec2();
            f += this.op(vec2);
        }
        this.aStore += f;
    }

    public void runWorldPoolTest() {
        float f = 0.0f;
        for (int i = 0; i < 1000000; ++i) {
            Vec2 vec2 = this.wp.popVec2();
            f += this.op(vec2);
            this.wp.pushVec2(1);
        }
        this.aStore += f;
    }

    public void runCirclePoolTest() {
        float f = 0.0f;
        for (int i = 0; i < 1000000; ++i) {
            Vec2 vec2 = this.cp.get();
            f += this.op(vec2);
        }
        this.aStore += f;
    }

    public void runThreadLocalTest() {
        float f = 0.0f;
        for (int i = 0; i < 1000000; ++i) {
            Vec2 vec2 = (Vec2)this.tlv.get();
            f += this.op(vec2);
        }
        this.aStore += f;
    }

    public void runCustStackTest() {
        float f = 0.0f;
        for (int i = 0; i < 1000000; ++i) {
            Vec2 vec2 = this.stack.get();
            f += this.op(vec2);
            this.stack.reduce(1);
        }
        this.aStore += f;
    }

    public void runMemberTest() {
        float f = 0.0f;
        for (int i = 0; i < 1000000; ++i) {
            f += this.op(this.mv);
        }
        this.aStore += f;
    }

    public String getTestName(int n) {
        return this.tests[n];
    }

    public static void main(String[] stringArray) {
        PoolingPerf poolingPerf = new PoolingPerf();
        poolingPerf.go();
    }

    public static class CirclePool {
        final Vec2[] pool = new Vec2[200];
        int index;
        final int length;

        public CirclePool() {
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = new Vec2();
            }
            this.length = 200;
            this.index = -1;
        }

        public final Vec2 get() {
            ++this.index;
            if (this.index >= this.length) {
                this.index = 0;
            }
            return this.pool[this.index];
        }
    }

    public static class CustStack {
        final Vec2[] pool = new Vec2[50];
        int index;

        public CustStack() {
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = new Vec2();
            }
            this.index = 0;
        }

        public final Vec2 get() {
            return this.pool[this.index++];
        }

        public final void reduce(int n) {
            this.index -= n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TLVec2
    extends ThreadLocal<Vec2> {
        @Override
        protected Vec2 initialValue() {
            return new Vec2();
        }
    }
}

