/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Jacobian;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.pooling.IWorldPool;

public class GearJoint
extends Joint {
    private Body m_ground1;
    private Body m_ground2;
    private RevoluteJoint m_revolute1;
    private PrismaticJoint m_prismatic1;
    private RevoluteJoint m_revolute2;
    private PrismaticJoint m_prismatic2;
    private final Vec2 m_groundAnchor1 = new Vec2();
    private final Vec2 m_groundAnchor2 = new Vec2();
    private final Vec2 m_localAnchor1 = new Vec2();
    private final Vec2 m_localAnchor2 = new Vec2();
    private final Jacobian m_J;
    private float m_constant;
    private float m_ratio;
    private float m_mass;
    private float m_impulse;

    public GearJoint(IWorldPool iWorldPool, GearJointDef gearJointDef) {
        super(iWorldPool, gearJointDef);
        float f;
        float f2;
        JointType jointType = gearJointDef.joint1.getType();
        JointType jointType2 = gearJointDef.joint2.getType();
        assert (jointType == JointType.REVOLUTE || jointType == JointType.PRISMATIC);
        assert (jointType2 == JointType.REVOLUTE || jointType2 == JointType.PRISMATIC);
        assert (gearJointDef.joint1.getBodyA().getType() == BodyType.STATIC);
        assert (gearJointDef.joint2.getBodyA().getType() == BodyType.STATIC);
        this.m_revolute1 = null;
        this.m_prismatic1 = null;
        this.m_revolute2 = null;
        this.m_prismatic2 = null;
        this.m_J = new Jacobian();
        this.m_ground1 = gearJointDef.joint1.getBodyA();
        this.m_bodyA = gearJointDef.joint1.getBodyB();
        if (jointType == JointType.REVOLUTE) {
            this.m_revolute1 = (RevoluteJoint)gearJointDef.joint1;
            this.m_groundAnchor1.set(this.m_revolute1.m_localAnchor1);
            this.m_localAnchor1.set(this.m_revolute1.m_localAnchor2);
            f2 = this.m_revolute1.getJointAngle();
        } else {
            this.m_prismatic1 = (PrismaticJoint)gearJointDef.joint1;
            this.m_groundAnchor1.set(this.m_prismatic1.m_localAnchor1);
            this.m_localAnchor1.set(this.m_prismatic1.m_localAnchor2);
            f2 = this.m_prismatic1.getJointTranslation();
        }
        this.m_ground2 = gearJointDef.joint2.getBodyA();
        this.m_bodyB = gearJointDef.joint2.getBodyB();
        if (jointType2 == JointType.REVOLUTE) {
            this.m_revolute2 = (RevoluteJoint)gearJointDef.joint2;
            this.m_groundAnchor2.set(this.m_revolute2.m_localAnchor1);
            this.m_localAnchor2.set(this.m_revolute2.m_localAnchor2);
            f = this.m_revolute2.getJointAngle();
        } else {
            this.m_prismatic2 = (PrismaticJoint)gearJointDef.joint2;
            this.m_groundAnchor2.set(this.m_prismatic2.m_localAnchor1);
            this.m_localAnchor2.set(this.m_prismatic2.m_localAnchor2);
            f = this.m_prismatic2.getJointTranslation();
        }
        this.m_ratio = gearJointDef.ratio;
        this.m_constant = f2 + this.m_ratio * f;
        this.m_impulse = 0.0f;
    }

    public void getAnchorA(Vec2 vec2) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, vec2);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_J.linearB).mulLocal(this.m_impulse);
        vec2.mulLocal(f);
    }

    public float getReactionTorque(float f) {
        Vec2 vec2 = this.pool.popVec2();
        Vec2 vec22 = this.pool.popVec2();
        vec2.set(this.m_localAnchor2).subLocal(this.m_bodyB.getLocalCenter());
        Mat22.mulToOut(this.m_bodyB.getTransform().R, vec2, vec2);
        vec22.set(this.m_J.linearB).mulLocal(this.m_impulse);
        float f2 = this.m_impulse * this.m_J.angularB - Vec2.cross(vec2, vec22);
        this.pool.pushVec2(2);
        return f * f2;
    }

    public void setRatio(float f) {
        this.m_ratio = f;
    }

    public float getRatio() {
        return this.m_ratio;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        float f;
        Vec2 vec2;
        Vec2 vec22;
        Body body = this.m_ground1;
        Body body2 = this.m_ground2;
        Body body3 = this.m_bodyA;
        Body body4 = this.m_bodyB;
        float f2 = 0.0f;
        this.m_J.setZero();
        if (this.m_revolute1 != null) {
            this.m_J.angularA = -1.0f;
            f2 += body3.m_invI;
        } else {
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            Mat22.mulToOut(body.getTransform().R, this.m_prismatic1.m_localXAxis1, vec22);
            vec2.set(this.m_localAnchor1).subLocal(body3.getLocalCenter());
            Mat22.mulToOut(body3.getTransform().R, vec2, vec2);
            f = Vec2.cross(vec2, vec22);
            this.m_J.linearA.set(vec22).negateLocal();
            this.m_J.angularA = -f;
            f2 += body3.m_invMass + body3.m_invI * f * f;
            this.pool.pushVec2(2);
        }
        if (this.m_revolute2 != null) {
            this.m_J.angularB = -this.m_ratio;
            f2 += this.m_ratio * this.m_ratio * body4.m_invI;
        } else {
            vec22 = this.pool.popVec2();
            vec2 = this.pool.popVec2();
            Mat22.mulToOut(body2.getTransform().R, this.m_prismatic2.m_localXAxis1, vec22);
            vec2.set(this.m_localAnchor2).subLocal(body4.getLocalCenter());
            Mat22.mulToOut(body4.getTransform().R, vec2, vec2);
            f = Vec2.cross(vec2, vec22);
            this.m_J.linearB.set(vec22).mulLocal(-this.m_ratio);
            this.m_J.angularB = -this.m_ratio * f;
            f2 += this.m_ratio * this.m_ratio * (body4.m_invMass + body4.m_invI * f * f);
            this.pool.pushVec2(2);
        }
        float f3 = this.m_mass = f2 > 0.0f ? 1.0f / f2 : 0.0f;
        if (timeStep.warmStarting) {
            vec22 = this.pool.popVec2();
            vec22.set(this.m_J.linearA).mulLocal(body3.m_invMass).mulLocal(this.m_impulse);
            body3.m_linearVelocity.addLocal(vec22);
            body3.m_angularVelocity += body3.m_invI * this.m_impulse * this.m_J.angularA;
            vec22.set(this.m_J.linearB).mulLocal(body4.m_invMass).mulLocal(this.m_impulse);
            body4.m_linearVelocity.addLocal(vec22);
            body4.m_angularVelocity += body4.m_invI * this.m_impulse * this.m_J.angularB;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse = 0.0f;
        }
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        float f = this.m_J.compute(body.m_linearVelocity, body.m_angularVelocity, body2.m_linearVelocity, body2.m_angularVelocity);
        float f2 = this.m_mass * -f;
        this.m_impulse += f2;
        Vec2 vec2 = this.pool.popVec2();
        vec2.set(this.m_J.linearA).mulLocal(body.m_invMass).mulLocal(f2);
        body.m_linearVelocity.addLocal(vec2);
        body.m_angularVelocity += body.m_invI * f2 * this.m_J.angularA;
        vec2.set(this.m_J.linearB).mulLocal(body2.m_invMass).mulLocal(f2);
        body2.m_linearVelocity.addLocal(vec2);
        body2.m_angularVelocity += body2.m_invI * f2 * this.m_J.angularB;
        this.pool.pushVec2(1);
    }

    public boolean solvePositionConstraints(float f) {
        float f2 = 0.0f;
        Body body = this.m_bodyA;
        Body body2 = this.m_bodyB;
        float f3 = this.m_revolute1 != null ? this.m_revolute1.getJointAngle() : this.m_prismatic1.getJointTranslation();
        float f4 = this.m_revolute2 != null ? this.m_revolute2.getJointAngle() : this.m_prismatic2.getJointTranslation();
        float f5 = this.m_constant - (f3 + this.m_ratio * f4);
        float f6 = this.m_mass * -f5;
        Vec2 vec2 = this.pool.popVec2();
        vec2.set(this.m_J.linearA).mulLocal(body.m_invMass).mulLocal(f6);
        body.m_sweep.c.addLocal(vec2);
        body.m_sweep.a += body.m_invI * f6 * this.m_J.angularA;
        vec2.set(this.m_J.linearB).mulLocal(body2.m_invMass).mulLocal(f6);
        body2.m_sweep.c.addLocal(vec2);
        body2.m_sweep.a += body2.m_invI * f6 * this.m_J.angularB;
        body.synchronizeTransform();
        body2.synchronizeTransform();
        this.pool.pushVec2(1);
        return f2 < Settings.linearSlop;
    }
}

