/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.ConstantVolumeJointDef;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;

public class ConstantVolumeJoint
extends Joint {
    Body[] bodies;
    float[] targetLengths;
    float targetVolume;
    Vec2[] normals;
    TimeStep m_step;
    private float m_impulse = 0.0f;
    private World world;
    DistanceJoint[] distanceJoints;

    public Body[] getBodies() {
        return this.bodies;
    }

    public void inflate(float f) {
        this.targetVolume *= f;
    }

    public ConstantVolumeJoint(World world, ConstantVolumeJointDef constantVolumeJointDef) {
        super(world.getPool(), constantVolumeJointDef);
        int n;
        this.world = world;
        if (constantVolumeJointDef.bodies.length <= 2) {
            throw new IllegalArgumentException("You cannot create a constant volume joint with less than three bodies.");
        }
        this.bodies = constantVolumeJointDef.bodies;
        this.targetLengths = new float[this.bodies.length];
        for (int i = 0; i < this.targetLengths.length; ++i) {
            float f;
            n = i == this.targetLengths.length - 1 ? 0 : i + 1;
            this.targetLengths[i] = f = this.bodies[i].getWorldCenter().sub(this.bodies[n].getWorldCenter()).length();
        }
        this.targetVolume = this.getArea();
        DistanceJointDef distanceJointDef = new DistanceJointDef();
        this.distanceJoints = new DistanceJoint[this.bodies.length];
        for (n = 0; n < this.targetLengths.length; ++n) {
            int n2 = n == this.targetLengths.length - 1 ? 0 : n + 1;
            distanceJointDef.frequencyHz = constantVolumeJointDef.frequencyHz;
            distanceJointDef.dampingRatio = constantVolumeJointDef.dampingRatio;
            distanceJointDef.initialize(this.bodies[n], this.bodies[n2], this.bodies[n].getWorldCenter(), this.bodies[n2].getWorldCenter());
            this.distanceJoints[n] = (DistanceJoint)this.world.createJoint(distanceJointDef);
        }
        this.normals = new Vec2[this.bodies.length];
        for (n = 0; n < this.normals.length; ++n) {
            this.normals[n] = new Vec2();
        }
        this.m_bodyA = this.bodies[0];
        this.m_bodyB = this.bodies[1];
        this.m_collideConnected = false;
    }

    public void destructor() {
        for (int i = 0; i < this.distanceJoints.length; ++i) {
            this.world.destroyJoint(this.distanceJoints[i]);
        }
    }

    private float getArea() {
        float f = 0.0f;
        f += this.bodies[this.bodies.length - 1].getWorldCenter().x * this.bodies[0].getWorldCenter().y - this.bodies[0].getWorldCenter().x * this.bodies[this.bodies.length - 1].getWorldCenter().y;
        for (int i = 0; i < this.bodies.length - 1; ++i) {
            f += this.bodies[i].getWorldCenter().x * this.bodies[i + 1].getWorldCenter().y - this.bodies[i + 1].getWorldCenter().x * this.bodies[i].getWorldCenter().y;
        }
        return f *= 0.5f;
    }

    public boolean constrainEdges(TimeStep timeStep) {
        float f;
        float f2 = 0.0f;
        for (int i = 0; i < this.bodies.length; ++i) {
            int n = i == this.bodies.length - 1 ? 0 : i + 1;
            f = this.bodies[n].getWorldCenter().x - this.bodies[i].getWorldCenter().x;
            float f3 = this.bodies[n].getWorldCenter().y - this.bodies[i].getWorldCenter().y;
            float f4 = MathUtils.sqrt(f * f + f3 * f3);
            if (f4 < 1.1920929E-7f) {
                f4 = 1.0f;
            }
            this.normals[i].x = f3 / f4;
            this.normals[i].y = -f / f4;
            f2 += f4;
        }
        Vec2 vec2 = this.pool.popVec2();
        float f5 = this.targetVolume - this.getArea();
        f = 0.5f * f5 / f2;
        boolean bl = true;
        for (int i = 0; i < this.bodies.length; ++i) {
            int n = i == this.bodies.length - 1 ? 0 : i + 1;
            vec2.set(f * (this.normals[i].x + this.normals[n].x), f * (this.normals[i].y + this.normals[n].y));
            float f6 = vec2.length();
            if (f6 > Settings.maxLinearCorrection) {
                vec2.mulLocal(Settings.maxLinearCorrection / f6);
            }
            if (f6 > Settings.linearSlop) {
                bl = false;
            }
            this.bodies[n].m_sweep.c.x += vec2.x;
            this.bodies[n].m_sweep.c.y += vec2.y;
            this.bodies[n].synchronizeTransform();
        }
        this.pool.pushVec2(1);
        return bl;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        int n;
        this.m_step = timeStep;
        Vec2[] vec2Array = this.pool.getVec2Array(this.bodies.length);
        for (n = 0; n < this.bodies.length; ++n) {
            int n2 = n == 0 ? this.bodies.length - 1 : n - 1;
            int n3 = n == this.bodies.length - 1 ? 0 : n + 1;
            vec2Array[n].set(this.bodies[n3].getWorldCenter());
            vec2Array[n].subLocal(this.bodies[n2].getWorldCenter());
        }
        if (timeStep.warmStarting) {
            this.m_impulse *= timeStep.dtRatio;
            for (n = 0; n < this.bodies.length; ++n) {
                this.bodies[n].m_linearVelocity.x += this.bodies[n].m_invMass * vec2Array[n].y * 0.5f * this.m_impulse;
                this.bodies[n].m_linearVelocity.y += this.bodies[n].m_invMass * -vec2Array[n].x * 0.5f * this.m_impulse;
            }
        } else {
            this.m_impulse = 0.0f;
        }
    }

    public boolean solvePositionConstraints(float f) {
        return this.constrainEdges(this.m_step);
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        int n;
        float f = 0.0f;
        float f2 = 0.0f;
        Vec2[] vec2Array = this.pool.getVec2Array(this.bodies.length);
        for (int i = 0; i < this.bodies.length; ++i) {
            n = i == 0 ? this.bodies.length - 1 : i - 1;
            int n2 = i == this.bodies.length - 1 ? 0 : i + 1;
            vec2Array[i].set(this.bodies[n2].getWorldCenter());
            vec2Array[i].subLocal(this.bodies[n].getWorldCenter());
            f2 += vec2Array[i].lengthSquared() / this.bodies[i].getMass();
            f += Vec2.cross(this.bodies[i].getLinearVelocity(), vec2Array[i]);
        }
        float f3 = -2.0f * f / f2;
        this.m_impulse += f3;
        for (n = 0; n < this.bodies.length; ++n) {
            this.bodies[n].m_linearVelocity.x += this.bodies[n].m_invMass * vec2Array[n].y * 0.5f * f3;
            this.bodies[n].m_linearVelocity.y += this.bodies[n].m_invMass * -vec2Array[n].x * 0.5f * f3;
        }
    }

    public void getAnchorA(Vec2 vec2) {
    }

    public void getAnchorB(Vec2 vec2) {
    }

    public void getReactionForce(float f, Vec2 vec2) {
    }

    public float getReactionTorque(float f) {
        return 0.0f;
    }
}

