/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.collision.Manifold;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.contacts.ContactConstraintPoint;

public class ContactConstraint {
    public final ContactConstraintPoint[] points = new ContactConstraintPoint[Settings.maxManifoldPoints];
    public final Vec2 localNormal;
    public final Vec2 localPoint;
    public final Vec2 normal;
    public final Mat22 normalMass;
    public final Mat22 K;
    public Body bodyA;
    public Body bodyB;
    public Manifold.ManifoldType type;
    public float radius;
    public float friction;
    public float restitution;
    public int pointCount;
    public Manifold manifold = null;

    public ContactConstraint() {
        for (int i = 0; i < Settings.maxManifoldPoints; ++i) {
            this.points[i] = new ContactConstraintPoint();
        }
        this.pointCount = 0;
        this.localNormal = new Vec2();
        this.localPoint = new Vec2();
        this.normal = new Vec2();
        this.normalMass = new Mat22();
        this.K = new Mat22();
    }

    public void set(ContactConstraint contactConstraint) {
        this.pointCount = contactConstraint.pointCount;
        this.localNormal.set(contactConstraint.localNormal);
        this.localPoint.set(contactConstraint.localPoint);
        this.normal.set(contactConstraint.normal);
        this.normalMass.set(contactConstraint.normalMass);
        this.K.set(contactConstraint.K);
        this.bodyA = contactConstraint.bodyA;
        this.bodyB = contactConstraint.bodyB;
        this.type = contactConstraint.type;
        this.radius = contactConstraint.radius;
        this.friction = contactConstraint.friction;
        this.restitution = contactConstraint.restitution;
        this.manifold = contactConstraint.manifold;
        for (int i = 0; i < contactConstraint.pointCount; ++i) {
            this.points[i].set(contactConstraint.points[i]);
        }
    }
}

