/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.callbacks.ContactFilter;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.DestructionListener;
import org.jbox2d.callbacks.QueryCallback;
import org.jbox2d.callbacks.RayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.TimeOfImpact;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.ContactManager;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.Island;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.WorldQueryWrapper;
import org.jbox2d.dynamics.WorldRayCastWrapper;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.contacts.ContactRegister;
import org.jbox2d.dynamics.contacts.TOISolver;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.pooling.IDynamicStack;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.WorldPool;
import org.jbox2d.pooling.arrays.Vec2Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class World {
    public static final int WORLD_POOL_SIZE = 100;
    public static final int WORLD_POOL_CONTAINER_SIZE = 10;
    public static final int NEW_FIXTURE = 1;
    public static final int LOCKED = 2;
    public static final int CLEAR_FORCES = 4;
    public int activeContacts = 0;
    public int contactPoolCount = 0;
    protected int m_flags;
    protected ContactManager m_contactManager;
    private Body m_bodyList;
    private Joint m_jointList;
    private int m_bodyCount;
    private int m_jointCount;
    private final Vec2 m_gravity = new Vec2();
    private boolean m_allowSleep;
    private DestructionListener m_destructionListener;
    private DebugDraw m_debugDraw;
    private final IWorldPool pool;
    private float m_inv_dt0;
    private boolean m_warmStarting;
    private boolean m_continuousPhysics;
    private ContactRegister[][] contactStacks = new ContactRegister[2][2];
    private final TimeStep step = new TimeStep();
    private final Color3f color = new Color3f();
    private final Transform xf = new Transform();
    private final Vec2 cA = new Vec2();
    private final Vec2 cB = new Vec2();
    private static final Vec2Array avs = new Vec2Array();
    private final WorldQueryWrapper wqwrapper = new WorldQueryWrapper();
    private final WorldRayCastWrapper wrcwrapper = new WorldRayCastWrapper();
    private final RayCastInput input = new RayCastInput();
    private final Island island = new Island();
    private Body[] stack = new Body[10];
    private final TimeOfImpact.TOIInput toiInput = new TimeOfImpact.TOIInput();
    private final TimeOfImpact.TOIOutput toiOutput = new TimeOfImpact.TOIOutput();
    private final Sweep backup = new Sweep();
    private final TOISolver toiSolver = new TOISolver();
    private Contact[] m_contacts = new Contact[Settings.maxTOIContacts];
    private static Integer LIQUID_INT = new Integer(1234598372);
    private float liquidLength = 0.12f;
    private float averageLinearVel = -1.0f;
    private final Vec2 liquidOffset = new Vec2();
    private final Vec2 circCenterMoved = new Vec2();
    private final Color3f liquidColor = new Color3f(0.4f, 0.4f, 1.0f);
    private final Vec2 center = new Vec2();
    private final Vec2 axis = new Vec2();
    private final Vec2Array tlvertices = new Vec2Array();

    public World(Vec2 vec2, boolean bl) {
        this(vec2, bl, new WorldPool(100, 10));
    }

    public World(Vec2 vec2, boolean bl, IWorldPool iWorldPool) {
        this.pool = iWorldPool;
        this.m_destructionListener = null;
        this.m_debugDraw = null;
        this.m_bodyList = null;
        this.m_jointList = null;
        this.m_bodyCount = 0;
        this.m_jointCount = 0;
        this.m_warmStarting = true;
        this.m_continuousPhysics = true;
        this.m_allowSleep = bl;
        this.m_gravity.set(vec2);
        this.m_flags = 4;
        this.m_inv_dt0 = 0.0f;
        this.m_contactManager = new ContactManager(this);
        this.initializeRegisters();
    }

    private void addType(IDynamicStack<Contact> iDynamicStack, ShapeType shapeType, ShapeType shapeType2) {
        ContactRegister contactRegister = new ContactRegister();
        contactRegister.creator = iDynamicStack;
        contactRegister.primary = true;
        this.contactStacks[shapeType.intValue][shapeType2.intValue] = contactRegister;
        if (shapeType != shapeType2) {
            ContactRegister contactRegister2 = new ContactRegister();
            contactRegister2.creator = iDynamicStack;
            contactRegister2.primary = false;
            this.contactStacks[shapeType2.intValue][shapeType.intValue] = contactRegister2;
        }
    }

    private void initializeRegisters() {
        this.addType(this.pool.getCircleContactStack(), ShapeType.CIRCLE, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyCircleContactStack(), ShapeType.POLYGON, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyContactStack(), ShapeType.POLYGON, ShapeType.POLYGON);
    }

    public Contact popContact(Fixture fixture, Fixture fixture2) {
        ShapeType shapeType = fixture.getType();
        ShapeType shapeType2 = fixture2.getType();
        ContactRegister contactRegister = this.contactStacks[shapeType.intValue][shapeType2.intValue];
        IDynamicStack<Contact> iDynamicStack = contactRegister.creator;
        if (iDynamicStack != null) {
            if (contactRegister.primary) {
                Contact contact = iDynamicStack.pop();
                contact.init(fixture, fixture2);
                return contact;
            }
            Contact contact = iDynamicStack.pop();
            contact.init(fixture2, fixture);
            return contact;
        }
        return null;
    }

    public void pushContact(Contact contact) {
        if (contact.m_manifold.pointCount > 0) {
            contact.getFixtureA().getBody().setAwake(true);
            contact.getFixtureB().getBody().setAwake(true);
        }
        ShapeType shapeType = contact.getFixtureA().getType();
        ShapeType shapeType2 = contact.getFixtureB().getType();
        IDynamicStack<Contact> iDynamicStack = this.contactStacks[shapeType.intValue][shapeType2.intValue].creator;
        iDynamicStack.push(contact);
    }

    public IWorldPool getPool() {
        return this.pool;
    }

    public void setDestructionListener(DestructionListener destructionListener) {
        this.m_destructionListener = destructionListener;
    }

    public void setContactFilter(ContactFilter contactFilter) {
        this.m_contactManager.m_contactFilter = contactFilter;
    }

    public void setContactListener(ContactListener contactListener) {
        this.m_contactManager.m_contactListener = contactListener;
    }

    public void setDebugDraw(DebugDraw debugDraw) {
        this.m_debugDraw = debugDraw;
    }

    public Body createBody(BodyDef bodyDef) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        Body body = new Body(bodyDef, this);
        body.m_prev = null;
        body.m_next = this.m_bodyList;
        if (this.m_bodyList != null) {
            this.m_bodyList.m_prev = body;
        }
        this.m_bodyList = body;
        ++this.m_bodyCount;
        return body;
    }

    public void destroyBody(Body body) {
        Object object;
        Object object2;
        assert (this.m_bodyCount > 0);
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        JointEdge jointEdge = body.m_jointList;
        while (jointEdge != null) {
            object2 = jointEdge;
            jointEdge = jointEdge.next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye(((JointEdge)object2).joint);
            }
            this.destroyJoint(((JointEdge)object2).joint);
        }
        body.m_jointList = null;
        object2 = body.m_contactList;
        while (object2 != null) {
            object = object2;
            object2 = ((ContactEdge)object2).next;
            this.m_contactManager.destroy(((ContactEdge)object).contact);
        }
        body.m_contactList = null;
        object = body.m_fixtureList;
        while (object != null) {
            Object object3 = object;
            object = ((Fixture)object).m_next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye((Fixture)object3);
            }
            ((Fixture)object3).destroyProxy(this.m_contactManager.m_broadPhase);
            ((Fixture)object3).destroy();
        }
        body.m_fixtureList = null;
        body.m_fixtureCount = 0;
        if (body.m_prev != null) {
            body.m_prev.m_next = body.m_next;
        }
        if (body.m_next != null) {
            body.m_next.m_prev = body.m_prev;
        }
        if (body == this.m_bodyList) {
            this.m_bodyList = body.m_next;
        }
        --this.m_bodyCount;
    }

    public Joint createJoint(JointDef jointDef) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return null;
        }
        Joint joint = Joint.create(this, jointDef);
        joint.m_prev = null;
        joint.m_next = this.m_jointList;
        if (this.m_jointList != null) {
            this.m_jointList.m_prev = joint;
        }
        this.m_jointList = joint;
        ++this.m_jointCount;
        joint.m_edgeA.joint = joint;
        joint.m_edgeA.other = joint.m_bodyB;
        joint.m_edgeA.prev = null;
        joint.m_edgeA.next = joint.m_bodyA.m_jointList;
        if (joint.m_bodyA.m_jointList != null) {
            joint.m_bodyA.m_jointList.prev = joint.m_edgeA;
        }
        joint.m_bodyA.m_jointList = joint.m_edgeA;
        joint.m_edgeB.joint = joint;
        joint.m_edgeB.other = joint.m_bodyA;
        joint.m_edgeB.prev = null;
        joint.m_edgeB.next = joint.m_bodyB.m_jointList;
        if (joint.m_bodyB.m_jointList != null) {
            joint.m_bodyB.m_jointList.prev = joint.m_edgeB;
        }
        joint.m_bodyB.m_jointList = joint.m_edgeB;
        Body body = jointDef.bodyA;
        Body body2 = jointDef.bodyB;
        if (!jointDef.collideConnected) {
            ContactEdge contactEdge = body2.getContactList();
            while (contactEdge != null) {
                if (contactEdge.other == body) {
                    contactEdge.contact.flagForFiltering();
                }
                contactEdge = contactEdge.next;
            }
        }
        return joint;
    }

    public void destroyJoint(Joint joint) {
        assert (!this.isLocked());
        if (this.isLocked()) {
            return;
        }
        boolean bl = joint.m_collideConnected;
        if (joint.m_prev != null) {
            joint.m_prev.m_next = joint.m_next;
        }
        if (joint.m_next != null) {
            joint.m_next.m_prev = joint.m_prev;
        }
        if (joint == this.m_jointList) {
            this.m_jointList = joint.m_next;
        }
        Body body = joint.m_bodyA;
        Body body2 = joint.m_bodyB;
        body.setAwake(true);
        body2.setAwake(true);
        if (joint.m_edgeA.prev != null) {
            joint.m_edgeA.prev.next = joint.m_edgeA.next;
        }
        if (joint.m_edgeA.next != null) {
            joint.m_edgeA.next.prev = joint.m_edgeA.prev;
        }
        if (joint.m_edgeA == body.m_jointList) {
            body.m_jointList = joint.m_edgeA.next;
        }
        joint.m_edgeA.prev = null;
        joint.m_edgeA.next = null;
        if (joint.m_edgeB.prev != null) {
            joint.m_edgeB.prev.next = joint.m_edgeB.next;
        }
        if (joint.m_edgeB.next != null) {
            joint.m_edgeB.next.prev = joint.m_edgeB.prev;
        }
        if (joint.m_edgeB == body2.m_jointList) {
            body2.m_jointList = joint.m_edgeB.next;
        }
        joint.m_edgeB.prev = null;
        joint.m_edgeB.next = null;
        Joint.destroy(joint);
        assert (this.m_jointCount > 0);
        --this.m_jointCount;
        if (!bl) {
            ContactEdge contactEdge = body2.getContactList();
            while (contactEdge != null) {
                if (contactEdge.other == body) {
                    contactEdge.contact.flagForFiltering();
                }
                contactEdge = contactEdge.next;
            }
        }
    }

    public void step(float f, int n, int n2) {
        if ((this.m_flags & 1) == 1) {
            this.m_contactManager.findNewContacts();
            this.m_flags &= 0xFFFFFFFE;
        }
        this.m_flags |= 2;
        this.step.dt = f;
        this.step.velocityIterations = n;
        this.step.positionIterations = n2;
        this.step.inv_dt = f > 0.0f ? 1.0f / f : 0.0f;
        this.step.dtRatio = this.m_inv_dt0 * f;
        this.step.warmStarting = this.m_warmStarting;
        this.m_contactManager.collide();
        if (this.step.dt > 0.0f) {
            this.solve(this.step);
        }
        if (this.m_continuousPhysics && this.step.dt > 0.0f) {
            this.solveTOI();
        }
        if (this.step.dt > 0.0f) {
            this.m_inv_dt0 = this.step.inv_dt;
        }
        if ((this.m_flags & 4) == 4) {
            this.clearForces();
        }
        this.m_flags &= 0xFFFFFFFD;
    }

    public void clearForces() {
        for (Body body = this.m_bodyList; body != null; body = body.getNext()) {
            body.m_force.setZero();
            body.m_torque = 0.0f;
        }
    }

    public void drawDebugData() {
        Object object;
        Fixture fixture;
        Object object2;
        if (this.m_debugDraw == null) {
            return;
        }
        int n = this.m_debugDraw.getFlags();
        if ((n & 1) == 1) {
            for (object2 = this.m_bodyList; object2 != null; object2 = ((Body)object2).getNext()) {
                this.xf.set(((Body)object2).getTransform());
                for (fixture = ((Body)object2).getFixtureList(); fixture != null; fixture = fixture.getNext()) {
                    if (!((Body)object2).isActive()) {
                        this.drawShape(fixture, this.xf, new Color3f(0.5f, 0.5f, 0.3f));
                        continue;
                    }
                    if (((Body)object2).getType() == BodyType.STATIC) {
                        this.drawShape(fixture, this.xf, new Color3f(0.5f, 0.9f, 0.5f));
                        continue;
                    }
                    if (((Body)object2).getType() == BodyType.KINEMATIC) {
                        this.drawShape(fixture, this.xf, new Color3f(0.5f, 0.5f, 0.9f));
                        continue;
                    }
                    if (!((Body)object2).isAwake()) {
                        this.drawShape(fixture, this.xf, new Color3f(0.6f, 0.6f, 0.6f));
                        continue;
                    }
                    this.drawShape(fixture, this.xf, new Color3f(0.9f, 0.7f, 0.7f));
                }
            }
        }
        if ((n & 2) == 2) {
            for (object2 = this.m_jointList; object2 != null; object2 = ((Joint)object2).getNext()) {
                this.drawJoint((Joint)object2);
            }
        }
        if ((n & 8) == 8) {
            this.color.set(0.3f, 0.9f, 0.9f);
            for (object2 = this.m_contactManager.m_contactList; object2 != null; object2 = ((Contact)object2).getNext()) {
                fixture = ((Contact)object2).getFixtureA();
                object = ((Contact)object2).getFixtureB();
                fixture.getAABB().getCenterToOut(this.cA);
                ((Fixture)object).getAABB().getCenterToOut(this.cB);
                this.m_debugDraw.drawSegment(this.cA, this.cB, this.color);
            }
        }
        if ((n & 4) == 4) {
            this.color.set(0.9f, 0.3f, 0.9f);
            for (object2 = this.m_bodyList; object2 != null; object2 = ((Body)object2).getNext()) {
                if (!((Body)object2).isActive()) continue;
                for (fixture = ((Body)object2).getFixtureList(); fixture != null; fixture = fixture.getNext()) {
                    object = fixture.m_proxy.aabb;
                    Vec2[] vec2Array = (Vec2[])avs.get(4);
                    vec2Array[0].set(((AABB)object).lowerBound.x, ((AABB)object).lowerBound.y);
                    vec2Array[1].set(((AABB)object).upperBound.x, ((AABB)object).lowerBound.y);
                    vec2Array[2].set(((AABB)object).upperBound.x, ((AABB)object).upperBound.y);
                    vec2Array[3].set(((AABB)object).lowerBound.x, ((AABB)object).upperBound.y);
                    this.m_debugDraw.drawPolygon(vec2Array, 4, this.color);
                    if ((((Body)object2).m_flags & 0x40) != 64) continue;
                    Vec2 vec2 = ((Body)object2).getWorldCenter();
                    this.m_debugDraw.drawPoint(vec2, 5.0f, this.color);
                }
            }
        }
        if ((n & 0x10) == 16) {
            for (object2 = this.m_bodyList; object2 != null; object2 = ((Body)object2).getNext()) {
                this.xf.set(((Body)object2).getTransform());
                this.xf.position.set(((Body)object2).getWorldCenter());
                this.m_debugDraw.drawTransform(this.xf);
            }
        }
        if ((n & 0x20) == 32) {
            this.m_contactManager.m_broadPhase.drawTree(this.m_debugDraw);
        }
    }

    public void queryAABB(QueryCallback queryCallback, AABB aABB) {
        this.wqwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wqwrapper.callback = queryCallback;
        this.m_contactManager.m_broadPhase.query(this.wqwrapper, aABB);
    }

    public void raycast(RayCastCallback rayCastCallback, Vec2 vec2, Vec2 vec22) {
        this.wrcwrapper.broadPhase = this.m_contactManager.m_broadPhase;
        this.wrcwrapper.callback = rayCastCallback;
        this.input.maxFraction = 1.0f;
        this.input.p1.set(vec2);
        this.input.p2.set(vec22);
        this.m_contactManager.m_broadPhase.raycast(this.wrcwrapper, this.input);
    }

    public Body getBodyList() {
        return this.m_bodyList;
    }

    public Joint getJointList() {
        return this.m_jointList;
    }

    public Contact getContactList() {
        return this.m_contactManager.m_contactList;
    }

    public void setWarmStarting(boolean bl) {
        this.m_warmStarting = bl;
    }

    public void setContinuousPhysics(boolean bl) {
        this.m_continuousPhysics = bl;
    }

    public int getProxyCount() {
        return this.m_contactManager.m_broadPhase.getProxyCount();
    }

    public int getBodyCount() {
        return this.m_bodyCount;
    }

    public int getJointCount() {
        return this.m_jointCount;
    }

    public int getContactCount() {
        return this.m_contactManager.m_contactCount;
    }

    public void setGravity(Vec2 vec2) {
        this.m_gravity.set(vec2);
    }

    public Vec2 getGravity() {
        return this.m_gravity;
    }

    public boolean isLocked() {
        return (this.m_flags & 2) == 2;
    }

    public void setAutoClearForces(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 4) : (this.m_flags &= 0xFFFFFFFB);
    }

    public boolean getAutoClearForces() {
        return (this.m_flags & 4) == 4;
    }

    private void solve(TimeStep timeStep) {
        this.island.init(this.m_bodyCount, this.m_contactManager.m_contactCount, this.m_jointCount, this.m_contactManager.m_contactListener);
        Object object = this.m_bodyList;
        while (object != null) {
            ((Body)object).m_flags &= 0xFFFFFFFE;
            object = ((Body)object).m_next;
        }
        object = this.m_contactManager.m_contactList;
        while (object != null) {
            ((Contact)object).m_flags &= 0xFFFFFFFE;
            object = ((Contact)object).m_next;
        }
        object = this.m_jointList;
        while (object != null) {
            ((Joint)object).m_islandFlag = false;
            object = ((Joint)object).m_next;
        }
        int n = this.m_bodyCount;
        if (this.stack.length < n) {
            this.stack = new Body[n];
        }
        Body body = this.m_bodyList;
        while (body != null) {
            if ((body.m_flags & 1) != 1 && body.isAwake() && body.isActive() && body.getType() != BodyType.STATIC) {
                Object object2;
                this.island.clear();
                int n2 = 0;
                this.stack[n2++] = body;
                body.m_flags |= 1;
                while (n2 > 0) {
                    Object object3;
                    Body body2 = this.stack[--n2];
                    assert (body2.isActive());
                    this.island.add(body2);
                    body2.setAwake(true);
                    if (body2.getType() == BodyType.STATIC) continue;
                    object2 = body2.m_contactList;
                    while (object2 != null) {
                        object3 = ((ContactEdge)object2).contact;
                        if ((((Contact)object3).m_flags & 1) != 1 && ((Contact)object3).isEnabled() && ((Contact)object3).isTouching()) {
                            boolean bl = ((Contact)object3).m_fixtureA.m_isSensor;
                            boolean bl2 = ((Contact)object3).m_fixtureB.m_isSensor;
                            if (!bl && !bl2) {
                                this.island.add((Contact)object3);
                                ((Contact)object3).m_flags |= 1;
                                Body body3 = ((ContactEdge)object2).other;
                                if ((body3.m_flags & 1) != 1) {
                                    assert (n2 < n);
                                    this.stack[n2++] = body3;
                                    body3.m_flags |= 1;
                                }
                            }
                        }
                        object2 = ((ContactEdge)object2).next;
                    }
                    object2 = body2.m_jointList;
                    while (object2 != null) {
                        if (!((JointEdge)object2).joint.m_islandFlag && ((Body)(object3 = ((JointEdge)object2).other)).isActive()) {
                            this.island.add(((JointEdge)object2).joint);
                            ((JointEdge)object2).joint.m_islandFlag = true;
                            if ((((Body)object3).m_flags & 1) != 1) {
                                assert (n2 < n);
                                this.stack[n2++] = object3;
                                ((Body)object3).m_flags |= 1;
                            }
                        }
                        object2 = ((JointEdge)object2).next;
                    }
                }
                this.island.solve(timeStep, this.m_gravity, this.m_allowSleep);
                for (int i = 0; i < this.island.m_bodyCount; ++i) {
                    object2 = this.island.m_bodies[i];
                    if (((Body)object2).getType() != BodyType.STATIC) continue;
                    ((Body)object2).m_flags &= 0xFFFFFFFE;
                }
            }
            body = body.m_next;
        }
        for (body = this.m_bodyList; body != null; body = body.getNext()) {
            if ((body.m_flags & 1) == 0 || body.getType() == BodyType.STATIC) continue;
            body.synchronizeFixtures();
        }
        this.m_contactManager.findNewContacts();
    }

    private void solveTOI() {
        Object object = this.m_contactManager.m_contactList;
        while (object != null) {
            ((Contact)object).m_flags |= 4;
            ((Contact)object).m_toiCount = 0.0f;
            object = ((Contact)object).m_next;
        }
        object = this.m_bodyList;
        while (object != null) {
            ((Body)object).m_flags = (((Body)object).m_flags & 1) == 0 || ((Body)object).getType() == BodyType.KINEMATIC || ((Body)object).getType() == BodyType.STATIC ? (((Body)object).m_flags |= 0x40) : (((Body)object).m_flags &= 0xFFFFFFBF);
            object = ((Body)object).m_next;
        }
        object = this.m_bodyList;
        while (object != null) {
            if ((((Body)object).m_flags & 0x40) != 64 && !((Body)object).isBullet()) {
                this.solveTOI((Body)object);
                ((Body)object).m_flags |= 0x40;
            }
            object = ((Body)object).m_next;
        }
        object = this.m_bodyList;
        while (object != null) {
            if ((((Body)object).m_flags & 0x40) != 64 && ((Body)object).isBullet()) {
                this.solveTOI((Body)object);
                ((Body)object).m_flags |= 0x40;
            }
            object = ((Body)object).m_next;
        }
    }

    private void solveTOI(Body body) {
        boolean bl;
        Fixture fixture;
        Fixture fixture2;
        Contact contact;
        BodyType bodyType;
        Body body2;
        ContactEdge contactEdge;
        int n;
        boolean bl2;
        Contact contact2 = null;
        float f = 1.0f;
        Body body3 = null;
        int n2 = 0;
        boolean bl3 = body.isBullet();
        do {
            n = 0;
            bl2 = false;
            contactEdge = body.m_contactList;
            while (contactEdge != null) {
                if (contactEdge.contact != contact2) {
                    body2 = contactEdge.other;
                    bodyType = body2.getType();
                    if (!(!bl3 ? bodyType == BodyType.DYNAMIC : (body2.m_flags & 0x40) == 0 || bodyType != BodyType.STATIC && (contactEdge.contact.m_flags & 0x10) != 0)) {
                        contact = contactEdge.contact;
                        if (contact.isEnabled() && !(contact.m_toiCount > 10.0f)) {
                            fixture2 = contact.m_fixtureA;
                            fixture = contact.m_fixtureB;
                            if (!fixture2.isSensor() && !fixture.isSensor()) {
                                Body body4 = fixture2.m_body;
                                Body body5 = fixture.m_body;
                                this.toiInput.proxyA.set(fixture2.getShape());
                                this.toiInput.proxyB.set(fixture.getShape());
                                this.toiInput.sweepA.set(body4.m_sweep);
                                this.toiInput.sweepB.set(body5.m_sweep);
                                this.toiInput.tMax = f;
                                this.pool.getTimeOfImpact().timeOfImpact(this.toiOutput, this.toiInput);
                                if (this.toiOutput.state == TimeOfImpact.TOIOutputState.TOUCHING && this.toiOutput.t < f) {
                                    contact2 = contact;
                                    f = this.toiOutput.t;
                                    body3 = body2;
                                    bl2 = true;
                                }
                                ++n;
                            }
                        }
                    }
                }
                contactEdge = contactEdge.next;
            }
        } while (bl2 && n > 1 && ++n2 < 50);
        if (contact2 == null) {
            body.advance(1.0f);
            return;
        }
        this.backup.set(body.m_sweep);
        body.advance(f);
        contact2.update(this.m_contactManager.m_contactListener);
        if (!contact2.isEnabled()) {
            body.m_sweep.set(this.backup);
            this.solveTOI(body);
        }
        contact2.m_toiCount += 1.0f;
        if (this.m_contacts == null || this.m_contacts.length < Settings.maxTOIContacts) {
            this.m_contacts = new Contact[Settings.maxTOIContacts];
        }
        n = 0;
        contactEdge = body.m_contactList;
        while (contactEdge != null && n < Settings.maxTOIContacts) {
            body2 = contactEdge.other;
            bodyType = body2.getType();
            if (bodyType != BodyType.DYNAMIC && (contact = contactEdge.contact).isEnabled()) {
                fixture2 = contact.m_fixtureA;
                fixture = contact.m_fixtureB;
                if (!fixture2.isSensor() && !fixture.isSensor()) {
                    if (contact != contact2) {
                        contact.update(this.m_contactManager.m_contactListener);
                    }
                    if (contact.isEnabled() && contact.isTouching()) {
                        this.m_contacts[n] = contact;
                        ++n;
                    }
                }
            }
            contactEdge = contactEdge.next;
        }
        this.toiSolver.initialize(this.m_contacts, n, body);
        float f2 = 0.75f;
        for (int i = 0; i < 20 && !(bl = this.toiSolver.solve(f2)); ++i) {
        }
        if (body3.getType() != BodyType.STATIC) {
            contact2.m_flags |= 0x10;
        }
    }

    private void drawJoint(Joint joint) {
        Body body = joint.getBodyA();
        Body body2 = joint.getBodyB();
        Transform transform = body.getTransform();
        Transform transform2 = body2.getTransform();
        Vec2 vec2 = transform.position;
        Vec2 vec22 = transform2.position;
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        joint.getAnchorA(vec23);
        joint.getAnchorB(vec24);
        this.color.set(0.5f, 0.8f, 0.8f);
        switch (joint.getType()) {
            case DISTANCE: {
                this.m_debugDraw.drawSegment(vec23, vec24, this.color);
                break;
            }
            case PULLEY: {
                PulleyJoint pulleyJoint = (PulleyJoint)joint;
                Vec2 vec25 = pulleyJoint.getGroundAnchorA();
                Vec2 vec26 = pulleyJoint.getGroundAnchorB();
                this.m_debugDraw.drawSegment(vec25, vec23, this.color);
                this.m_debugDraw.drawSegment(vec26, vec24, this.color);
                this.m_debugDraw.drawSegment(vec25, vec26, this.color);
                break;
            }
            case CONSTANT_VOLUME: 
            case MOUSE: {
                break;
            }
            default: {
                this.m_debugDraw.drawSegment(vec2, vec23, this.color);
                this.m_debugDraw.drawSegment(vec23, vec24, this.color);
                this.m_debugDraw.drawSegment(vec22, vec24, this.color);
            }
        }
        this.pool.pushVec2(2);
    }

    private void drawShape(Fixture fixture, Transform transform, Color3f color3f) {
        switch (fixture.getType()) {
            case CIRCLE: {
                CircleShape circleShape = (CircleShape)fixture.getShape();
                Transform.mulToOut(transform, circleShape.m_p, this.center);
                float f = circleShape.m_radius;
                this.axis.set(transform.R.col1);
                if (fixture.getUserData() != null && fixture.getUserData().equals(LIQUID_INT)) {
                    Body body = fixture.getBody();
                    this.liquidOffset.set(body.m_linearVelocity);
                    float f2 = body.m_linearVelocity.length();
                    this.averageLinearVel = this.averageLinearVel == -1.0f ? f2 : 0.98f * this.averageLinearVel + 0.02f * f2;
                    this.liquidOffset.mulLocal(this.liquidLength / this.averageLinearVel / 2.0f);
                    this.circCenterMoved.set(this.center).addLocal(this.liquidOffset);
                    this.center.subLocal(this.liquidOffset);
                    this.m_debugDraw.drawSegment(this.center, this.circCenterMoved, this.liquidColor);
                    return;
                }
                this.m_debugDraw.drawSolidCircle(this.center, f, this.axis, color3f);
                break;
            }
            case POLYGON: {
                PolygonShape polygonShape = (PolygonShape)fixture.getShape();
                int n = polygonShape.m_vertexCount;
                assert (n <= Settings.maxPolygonVertices);
                Vec2[] vec2Array = (Vec2[])this.tlvertices.get(Settings.maxPolygonVertices);
                for (int i = 0; i < n; ++i) {
                    Transform.mulToOut(transform, polygonShape.m_vertices[i], vec2Array[i]);
                }
                this.m_debugDraw.drawSolidPolygon(vec2Array, n, color3f);
            }
        }
    }
}

