/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class Sweep
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 localCenter = new Vec2();
    public final Vec2 c0 = new Vec2();
    public final Vec2 c = new Vec2();
    public float a0;
    public float a;

    public String toString() {
        String string = "Sweep:\nlocalCenter: " + this.localCenter + "\n";
        string = string + "c0: " + this.c0 + ", c: " + this.c + "\n";
        string = string + "a0: " + this.a0 + ", a: " + this.a + "\n";
        return string;
    }

    public final void normalize() {
        float f = (float)Math.PI * 2 * (float)MathUtils.floor(this.a0 / ((float)Math.PI * 2));
        this.a0 -= f;
        this.a -= f;
    }

    public final Sweep set(Sweep sweep) {
        this.localCenter.set(sweep.localCenter);
        this.c0.set(sweep.c0);
        this.c.set(sweep.c);
        this.a0 = sweep.a0;
        this.a = sweep.a;
        return this;
    }

    public final void getTransform(Transform transform, float f) {
        assert (transform != null);
        transform.position.x = (1.0f - f) * this.c0.x + f * this.c.x;
        transform.position.y = (1.0f - f) * this.c0.y + f * this.c.y;
        transform.R.set((1.0f - f) * this.a0 + f * this.a);
        transform.position.x -= transform.R.col1.x * this.localCenter.x + transform.R.col2.x * this.localCenter.y;
        transform.position.y -= transform.R.col1.y * this.localCenter.x + transform.R.col2.y * this.localCenter.y;
    }

    public final void advance(float f) {
        this.c0.x = (1.0f - f) * this.c0.x + f * this.c.x;
        this.c0.y = (1.0f - f) * this.c0.y + f * this.c.y;
        this.a0 = (1.0f - f) * this.a0 + f * this.a;
    }
}

