/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;

public class OBBViewportTransform
implements IViewportTransform {
    protected final OBB box = new OBB();
    private boolean yFlip = false;
    private final Mat22 yFlipMat = new Mat22(1.0f, 0.0f, 0.0f, -1.0f);
    private final Mat22 yFlipMatInv = this.yFlipMat.invert();
    private final Mat22 inv = new Mat22();
    private final Mat22 inv2 = new Mat22();

    public OBBViewportTransform() {
        this.box.R.setIdentity();
    }

    public void set(OBBViewportTransform oBBViewportTransform) {
        this.box.center.set(oBBViewportTransform.box.center);
        this.box.extents.set(oBBViewportTransform.box.extents);
        this.box.R.set(oBBViewportTransform.box.R);
        this.yFlip = oBBViewportTransform.yFlip;
    }

    public void setCamera(float f, float f2, float f3) {
        this.box.center.set(f, f2);
        Mat22.createScaleTransform(f3, this.box.R);
    }

    public Vec2 getExtents() {
        return this.box.extents;
    }

    public void setExtents(Vec2 vec2) {
        this.box.extents.set(vec2);
    }

    public void setExtents(float f, float f2) {
        this.box.extents.set(f, f2);
    }

    public Vec2 getCenter() {
        return this.box.center;
    }

    public void setCenter(Vec2 vec2) {
        this.box.center.set(vec2);
    }

    public void setCenter(float f, float f2) {
        this.box.center.set(f, f2);
    }

    public Mat22 getTransform() {
        return this.box.R;
    }

    public void setTransform(Mat22 mat22) {
        this.box.R.set(mat22);
    }

    public void mulByTransform(Mat22 mat22) {
        this.box.R.mulLocal(mat22);
    }

    public boolean isYFlip() {
        return this.yFlip;
    }

    public void setYFlip(boolean bl) {
        this.yFlip = bl;
    }

    public void getScreenVectorToWorld(Vec2 vec2, Vec2 vec22) {
        this.inv.set(this.box.R);
        this.inv.invertLocal();
        this.inv.mulToOut(vec2, vec22);
        if (this.yFlip) {
            this.yFlipMatInv.mulToOut(vec22, vec22);
        }
    }

    public void getWorldVectorToScreen(Vec2 vec2, Vec2 vec22) {
        this.box.R.mulToOut(vec2, vec22);
        if (this.yFlip) {
            this.yFlipMatInv.mulToOut(vec22, vec22);
        }
    }

    public void getWorldToScreen(Vec2 vec2, Vec2 vec22) {
        vec22.set(vec2);
        vec22.subLocal(this.box.center);
        this.box.R.mulToOut(vec22, vec22);
        if (this.yFlip) {
            this.yFlipMat.mulToOut(vec22, vec22);
        }
        vec22.addLocal(this.box.extents);
    }

    public void getScreenToWorld(Vec2 vec2, Vec2 vec22) {
        vec22.set(vec2);
        vec22.subLocal(this.box.extents);
        this.box.R.invertToOut(this.inv2);
        this.inv2.mulToOut(vec22, vec22);
        if (this.yFlip) {
            this.yFlipMatInv.mulToOut(vec22, vec22);
        }
        vec22.addLocal(this.box.center);
    }

    public static class OBB {
        public final Mat22 R = new Mat22();
        public final Vec2 center = new Vec2();
        public final Vec2 extents = new Vec2();
    }
}

