/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;

public class Mat33
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Mat33 IDENTITY = new Mat33(new Vec3(1.0f, 0.0f, 0.0f), new Vec3(0.0f, 1.0f, 0.0f), new Vec3(0.0f, 0.0f, 1.0f));
    public final Vec3 col1;
    public final Vec3 col2;
    public final Vec3 col3;

    public Mat33() {
        this.col1 = new Vec3();
        this.col2 = new Vec3();
        this.col3 = new Vec3();
    }

    public Mat33(Vec3 vec3, Vec3 vec32, Vec3 vec33) {
        this.col1 = vec3.clone();
        this.col2 = vec32.clone();
        this.col3 = vec33.clone();
    }

    public void setZero() {
        this.col1.setZero();
        this.col2.setZero();
        this.col3.setZero();
    }

    public static final Vec3 mul(Mat33 mat33, Vec3 vec3) {
        return new Vec3(vec3.x * mat33.col1.x + vec3.y * mat33.col2.x + vec3.z + mat33.col3.x, vec3.x * mat33.col1.y + vec3.y * mat33.col2.y + vec3.z * mat33.col3.y, vec3.x * mat33.col1.z + vec3.y * mat33.col2.z + vec3.z * mat33.col3.z);
    }

    public static final void mulToOut(Mat33 mat33, Vec3 vec3, Vec3 vec32) {
        float f = vec3.x * mat33.col1.y + vec3.y * mat33.col2.y + vec3.z * mat33.col3.y;
        float f2 = vec3.x * mat33.col1.z + vec3.y * mat33.col2.z + vec3.z * mat33.col3.z;
        vec32.x = vec3.x * mat33.col1.x + vec3.y * mat33.col2.x + vec3.z + mat33.col3.x;
        vec32.y = f;
        vec32.z = f2;
    }

    public final Vec2 solve22(Vec2 vec2) {
        Vec2 vec22 = new Vec2();
        this.solve22ToOut(vec2, vec22);
        return vec22;
    }

    public final void solve22ToOut(Vec2 vec2, Vec2 vec22) {
        float f = this.col1.x;
        float f2 = this.col2.y;
        float f3 = this.col2.x;
        float f4 = this.col1.y;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            f5 = 1.0f / f5;
        }
        vec22.x = f5 * (f2 * vec2.x - f3 * vec2.y);
        vec22.y = f5 * (f * vec2.y - f4 * vec2.x);
    }

    public final Vec3 solve33(Vec3 vec3) {
        Vec3 vec32 = new Vec3();
        this.solve33ToOut(vec3, vec32);
        return vec32;
    }

    public final void solve33ToOut(Vec3 vec3, Vec3 vec32) {
        Vec3.crossToOut(this.col2, this.col3, vec32);
        float f = Vec3.dot(this.col1, vec32);
        if (f != 0.0f) {
            f = 1.0f / f;
        }
        Vec3.crossToOut(this.col2, this.col3, vec32);
        float f2 = f * Vec3.dot(vec3, vec32);
        Vec3.crossToOut(vec3, this.col3, vec32);
        float f3 = f * Vec3.dot(this.col1, vec32);
        Vec3.crossToOut(this.col2, vec3, vec32);
        float f4 = f * Vec3.dot(this.col1, vec32);
        vec32.x = f2;
        vec32.y = f3;
        vec32.z = f4;
    }
}

