/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.Distance;
import org.jbox2d.collision.Type;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

class SeparationFunction {
    public Distance.DistanceProxy m_proxyA;
    public Distance.DistanceProxy m_proxyB;
    public Type m_type;
    public final Vec2 m_localPoint = new Vec2();
    public final Vec2 m_axis = new Vec2();
    public Sweep m_sweepA;
    public Sweep m_sweepB;
    private final Vec2 localPointA = new Vec2();
    private final Vec2 localPointB = new Vec2();
    private final Vec2 pointA = new Vec2();
    private final Vec2 pointB = new Vec2();
    private final Vec2 localPointA1 = new Vec2();
    private final Vec2 localPointA2 = new Vec2();
    private final Vec2 normal = new Vec2();
    private final Vec2 localPointB1 = new Vec2();
    private final Vec2 localPointB2 = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Transform xfa = new Transform();
    private final Transform xfb = new Transform();
    private final Vec2 axisA = new Vec2();
    private final Vec2 axisB = new Vec2();

    SeparationFunction() {
    }

    public float initialize(Distance.SimplexCache simplexCache, Distance.DistanceProxy distanceProxy, Sweep sweep, Distance.DistanceProxy distanceProxy2, Sweep sweep2, float f) {
        this.m_proxyA = distanceProxy;
        this.m_proxyB = distanceProxy2;
        int n = simplexCache.count;
        assert (0 < n && n < 3);
        this.m_sweepA = sweep;
        this.m_sweepB = sweep2;
        this.m_sweepA.getTransform(this.xfa, f);
        this.m_sweepB.getTransform(this.xfb, f);
        if (n == 1) {
            this.m_type = Type.POINTS;
            this.localPointA.set(this.m_proxyA.getVertex(simplexCache.indexA[0]));
            this.localPointB.set(this.m_proxyB.getVertex(simplexCache.indexB[0]));
            Transform.mulToOut(this.xfa, this.localPointA, this.pointA);
            Transform.mulToOut(this.xfb, this.localPointB, this.pointB);
            this.m_axis.set(this.pointB).subLocal(this.pointA);
            float f2 = this.m_axis.normalize();
            return f2;
        }
        if (simplexCache.indexA[0] == simplexCache.indexA[1]) {
            this.m_type = Type.FACE_B;
            this.localPointB1.set(this.m_proxyB.getVertex(simplexCache.indexB[0]));
            this.localPointB2.set(this.m_proxyB.getVertex(simplexCache.indexB[1]));
            this.temp.set(this.localPointB2).subLocal(this.localPointB1);
            Vec2.crossToOut(this.temp, 1.0f, this.m_axis);
            this.m_axis.normalize();
            Mat22.mulToOut(this.xfb.R, this.m_axis, this.normal);
            this.m_localPoint.set(this.localPointB1).addLocal(this.localPointB2).mulLocal(0.5f);
            Transform.mulToOut(this.xfb, this.m_localPoint, this.pointB);
            this.localPointA.set(distanceProxy.getVertex(simplexCache.indexA[0]));
            Transform.mulToOut(this.xfa, this.localPointA, this.pointA);
            this.temp.set(this.pointA).subLocal(this.pointB);
            float f3 = Vec2.dot(this.temp, this.normal);
            if (f3 < 0.0f) {
                this.m_axis.negateLocal();
                f3 = -f3;
            }
            return f3;
        }
        this.m_type = Type.FACE_A;
        this.localPointA1.set(this.m_proxyA.getVertex(simplexCache.indexA[0]));
        this.localPointA2.set(this.m_proxyA.getVertex(simplexCache.indexA[1]));
        this.temp.set(this.localPointA2).subLocal(this.localPointA1);
        Vec2.crossToOut(this.temp, 1.0f, this.m_axis);
        this.m_axis.normalize();
        Mat22.mulToOut(this.xfa.R, this.m_axis, this.normal);
        this.m_localPoint.set(this.localPointA1).addLocal(this.localPointA2).mulLocal(0.5f);
        Transform.mulToOut(this.xfa, this.m_localPoint, this.pointA);
        this.localPointB.set(this.m_proxyB.getVertex(simplexCache.indexB[0]));
        Transform.mulToOut(this.xfb, this.localPointB, this.pointB);
        this.temp.set(this.pointB).subLocal(this.pointA);
        float f4 = Vec2.dot(this.temp, this.normal);
        if (f4 < 0.0f) {
            this.m_axis.negateLocal();
            f4 = -f4;
        }
        return f4;
    }

    public float findMinSeparation(int[] nArray, float f) {
        this.m_sweepA.getTransform(this.xfa, f);
        this.m_sweepB.getTransform(this.xfb, f);
        switch (this.m_type) {
            case POINTS: {
                Mat22.mulTransToOut(this.xfa.R, this.m_axis, this.axisA);
                Mat22.mulTransToOut(this.xfb.R, this.m_axis.negateLocal(), this.axisB);
                this.m_axis.negateLocal();
                nArray[0] = this.m_proxyA.getSupport(this.axisA);
                nArray[1] = this.m_proxyB.getSupport(this.axisB);
                this.localPointA.set(this.m_proxyA.getVertex(nArray[0]));
                this.localPointB.set(this.m_proxyB.getVertex(nArray[1]));
                Transform.mulToOut(this.xfa, this.localPointA, this.pointA);
                Transform.mulToOut(this.xfb, this.localPointB, this.pointB);
                float f2 = Vec2.dot(this.pointB.subLocal(this.pointA), this.m_axis);
                return f2;
            }
            case FACE_A: {
                Mat22.mulToOut(this.xfa.R, this.m_axis, this.normal);
                Transform.mulToOut(this.xfa, this.m_localPoint, this.pointA);
                Mat22.mulTransToOut(this.xfb.R, this.normal.negateLocal(), this.axisB);
                this.normal.negateLocal();
                nArray[0] = -1;
                nArray[1] = this.m_proxyB.getSupport(this.axisB);
                this.localPointB.set(this.m_proxyB.getVertex(nArray[1]));
                Transform.mulToOut(this.xfb, this.localPointB, this.pointB);
                float f3 = Vec2.dot(this.pointB.subLocal(this.pointA), this.normal);
                return f3;
            }
            case FACE_B: {
                Mat22.mulToOut(this.xfb.R, this.m_axis, this.normal);
                Transform.mulToOut(this.xfb, this.m_localPoint, this.pointB);
                Mat22.mulTransToOut(this.xfa.R, this.normal.negateLocal(), this.axisA);
                this.normal.negateLocal();
                nArray[1] = -1;
                nArray[0] = this.m_proxyA.getSupport(this.axisA);
                this.localPointA.set(this.m_proxyA.getVertex(nArray[0]));
                Transform.mulToOut(this.xfa, this.localPointA, this.pointA);
                float f4 = Vec2.dot(this.pointA.subLocal(this.pointB), this.normal);
                return f4;
            }
        }
        assert (false);
        nArray[0] = -1;
        nArray[1] = -1;
        return 0.0f;
    }

    public float evaluate(int n, int n2, float f) {
        this.m_sweepA.getTransform(this.xfa, f);
        this.m_sweepB.getTransform(this.xfb, f);
        switch (this.m_type) {
            case POINTS: {
                Mat22.mulTransToOut(this.xfa.R, this.m_axis, this.axisA);
                Mat22.mulTransToOut(this.xfb.R, this.m_axis.negateLocal(), this.axisB);
                this.m_axis.negateLocal();
                this.localPointA.set(this.m_proxyA.getVertex(n));
                this.localPointB.set(this.m_proxyB.getVertex(n2));
                Transform.mulToOut(this.xfa, this.localPointA, this.pointA);
                Transform.mulToOut(this.xfb, this.localPointB, this.pointB);
                float f2 = Vec2.dot(this.pointB.subLocal(this.pointA), this.m_axis);
                return f2;
            }
            case FACE_A: {
                Mat22.mulToOut(this.xfa.R, this.m_axis, this.normal);
                Transform.mulToOut(this.xfa, this.m_localPoint, this.pointA);
                Mat22.mulTransToOut(this.xfb.R, this.normal.negateLocal(), this.axisB);
                this.normal.negateLocal();
                this.localPointB.set(this.m_proxyB.getVertex(n2));
                Transform.mulToOut(this.xfb, this.localPointB, this.pointB);
                float f3 = Vec2.dot(this.pointB.subLocal(this.pointA), this.normal);
                return f3;
            }
            case FACE_B: {
                Mat22.mulToOut(this.xfb.R, this.m_axis, this.normal);
                Transform.mulToOut(this.xfb, this.m_localPoint, this.pointB);
                Mat22.mulTransToOut(this.xfa.R, this.normal.negateLocal(), this.axisA);
                this.normal.negateLocal();
                this.localPointA.set(this.m_proxyA.getVertex(n));
                Transform.mulToOut(this.xfa, this.localPointA, this.pointA);
                float f4 = Vec2.dot(this.pointA.subLocal(this.pointB), this.normal);
                return f4;
            }
        }
        assert (false);
        return 0.0f;
    }
}

