/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;

public class Manifold {
    public final ManifoldPoint[] points = new ManifoldPoint[Settings.maxManifoldPoints];
    public final Vec2 localNormal;
    public final Vec2 localPoint;
    public ManifoldType type;
    public int pointCount;

    public Manifold() {
        for (int i = 0; i < Settings.maxManifoldPoints; ++i) {
            this.points[i] = new ManifoldPoint();
        }
        this.localNormal = new Vec2();
        this.localPoint = new Vec2();
        this.pointCount = 0;
    }

    public Manifold(Manifold manifold) {
        this.localNormal = manifold.localNormal.clone();
        this.localPoint = manifold.localPoint.clone();
        this.pointCount = manifold.pointCount;
        this.type = manifold.type;
        for (int i = 0; i < Settings.maxManifoldPoints; ++i) {
            this.points[i] = new ManifoldPoint(manifold.points[i]);
        }
    }

    public void set(Manifold manifold) {
        for (int i = 0; i < manifold.pointCount; ++i) {
            this.points[i].set(manifold.points[i]);
        }
        this.type = manifold.type;
        this.localNormal.set(manifold.localNormal);
        this.localPoint.set(manifold.localPoint);
        this.pointCount = manifold.pointCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ManifoldType {
        CIRCLES,
        FACE_A,
        FACE_B;

    }
}

