/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaltIon
extends Compound<SphericalParticle> {
    private final String name;

    public SaltIon(SphericalParticle sphericalParticle, String string) {
        super(ImmutableVector2D.ZERO, 0.0);
        this.name = string;
        this.addConstituent(new Constituent<SphericalParticle>(sphericalParticle, ImmutableVector2D.ZERO));
    }

    public String getName() {
        return this.name;
    }

    public static class ChlorideIon
    extends SaltIon {
        public ChlorideIon() {
            super(new SphericalParticle.Chloride(), SugarAndSaltSolutionsResources.Strings.CHLORIDE);
        }
    }

    public static class SodiumIon
    extends SaltIon {
        public SodiumIon() {
            super(new SphericalParticle.Sodium(), SugarAndSaltSolutionsResources.Strings.SODIUM);
        }
    }
}

