/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.view;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.FloatingClockControlNode;
import edu.colorado.phet.sugarandsaltsolutions.GlobalState;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.barchart.BarItem;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.ExpandableConcentrationBarChartNode;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.MicroKitControlNode;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.MicroSoluteKitList;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.RemoveSolutesButton;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.SphericalParticleNodeFactory;
import edu.colorado.phet.sugarandsaltsolutions.micro.view.periodictable.PeriodicTableDialog;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;

public class MicroCanvas
extends BeakerAndShakerCanvas
implements Module.Listener {
    private PeriodicTableDialog periodicTableDialog;
    private boolean dialogVisibleOnActivate;
    private final boolean debugBindingSites = false;
    private final PNode microKitControlNode;
    private final GlobalState globalState;

    public MicroCanvas(final MicroModel microModel, final GlobalState globalState) {
        super(microModel, globalState, MicroCanvas.createMicroTransform(microModel), true, false);
        this.globalState = globalState;
        final MicroSoluteKitList microSoluteKitList = new MicroSoluteKitList(microModel, this.transform);
        ExpandableConcentrationBarChartNode expandableConcentrationBarChartNode = new ExpandableConcentrationBarChartNode(microModel.showConcentrationBarChart, microModel.showConcentrationValues, new BarItem[0]){
            {
                super(property, settableProperty, barItemArray);
                this.setOffset(MicroCanvas.this.stageSize.getWidth() - this.getFullBoundsReference().width - 5.0, 5.0);
                microModel.selectedKit.addObserver(new VoidFunction1<Integer>(){

                    @Override
                    public void apply(Integer n) {
                        this.setBars(microSoluteKitList.getKit((int)n.intValue()).barItems);
                    }
                });
            }
        };
        this.behindShakerNode.addChild(expandableConcentrationBarChartNode);
        this.addChild(new RemoveSolutesButton(SugarAndSaltSolutionsResources.Strings.REMOVE_SOLUTE, microModel.numberSoluteTypes.valueEquals(1.0), microModel){
            {
                this.setOffset(MicroCanvas.this.evaporationSlider.getFullBounds().getMaxX() + 5.0, MicroCanvas.this.evaporationSlider.getFullBounds().getY());
            }
        });
        this.addChild(new RemoveSolutesButton(SugarAndSaltSolutionsResources.Strings.REMOVE_SOLUTES, microModel.numberSoluteTypes.greaterThan(1.0), microModel){
            {
                this.setOffset(MicroCanvas.this.evaporationSlider.getFullBounds().getMaxX() + 5.0, MicroCanvas.this.evaporationSlider.getFullBounds().getY());
            }
        });
        TextButtonNode textButtonNode = new TextButtonNode(SugarAndSaltSolutionsResources.Strings.PERIODIC_TABLE, CONTROL_FONT, Color.yellow){
            {
                super(string, font, color);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (MicroCanvas.this.periodicTableDialog == null) {
                            MicroCanvas.this.periodicTableDialog = new PeriodicTableDialog(microModel.dispenserType, globalState.colorScheme, globalState.frame){
                                {
                                    Rectangle rectangle = globalState.frame.getBounds();
                                    Rectangle rectangle2 = new Rectangle((int)(rectangle.getMinX() + 15.0), (int)(rectangle.getMinY() + MicroCanvas.this.getKitControlNodeY() + 10.0), this.getWidth(), this.getHeight());
                                    this.setLocation(rectangle2.x, rectangle2.y);
                                }
                            };
                        }
                        MicroCanvas.this.periodicTableDialog.setVisible(true);
                    }
                });
            }
        };
        this.microKitControlNode = new ZeroOffsetNode(new MicroKitControlNode(microModel.selectedKit, microModel.dispenserType, textButtonNode, globalState.singleMicroKit){
            {
                super(property, property2, textButtonNode, bl);
                microModel.addResetListener(new VoidFunction0(){

                    public void apply() {
                        kitSelectionNode.selectedKit.set(0);
                    }
                });
            }
        });
        this.microKitControlNode.setOffset(expandableConcentrationBarChartNode.getFullBounds().getX() - this.microKitControlNode.getFullBounds().getWidth() - 5.0 - 10.0, expandableConcentrationBarChartNode.getFullBounds().getY());
        this.behindShakerNode.addChild(this.microKitControlNode);
        microModel.addResetListener(new VoidFunction0(){

            public void apply() {
                if (MicroCanvas.this.periodicTableDialog != null) {
                    MicroCanvas.this.periodicTableDialog.dispose();
                    MicroCanvas.this.periodicTableDialog = null;
                }
            }
        });
        microModel.sphericalParticles.addElementAddedObserver(new SphericalParticleNodeFactory(microModel.sphericalParticles, this.transform, this, microModel.showChargeColor));
        this.addChild(new FloatingClockControlNode(microModel.clockRunning, NO_READOUT, microModel.clock, "", new Property<Color>(Color.white)){
            {
                this.setOffset(0.0, MicroCanvas.this.stageSize.getHeight() - this.getFullBounds().getHeight());
            }
        });
    }

    private double getKitControlNodeY() {
        return this.microKitControlNode.getFullBounds().getMaxY() + SwingUtilities.convertPoint(this, 0, 0, this.globalState.frame).getY();
    }

    public void activated() {
        if (this.periodicTableDialog != null && this.dialogVisibleOnActivate) {
            this.periodicTableDialog.setVisible(true);
        }
    }

    public void deactivated() {
        if (this.periodicTableDialog != null) {
            this.dialogVisibleOnActivate = this.periodicTableDialog.isVisible();
            this.periodicTableDialog.setVisible(false);
        }
    }

    public static ModelViewTransform createMicroTransform(SugarAndSaltSolutionModel sugarAndSaltSolutionModel) {
        double d = 0.75;
        return ModelViewTransform.createRectangleInvertedYMapping(sugarAndSaltSolutionModel.visibleRegion.toRectangle2D(), new Rectangle2D.Double(42.0, 135.0, (double)MicroCanvas.canvasSize.width * d, (double)MicroCanvas.canvasSize.height * d));
    }
}

