/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.FreeParticleStrategy;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.UpdateStrategy;

public class FlowToDrainStrategy
extends UpdateStrategy {
    private final ImmutableVector2D velocity;
    private final boolean randomWalk;

    public FlowToDrainStrategy(MicroModel microModel, ImmutableVector2D immutableVector2D, boolean bl) {
        super(microModel);
        this.velocity = immutableVector2D;
        this.randomWalk = bl;
    }

    public void stepInTime(Particle particle, double d) {
        if ((Double)this.model.outputFlowRate.get() == 0.0) {
            particle.setUpdateStrategy(new FreeParticleStrategy(this.model));
        } else {
            if (this.randomWalk) {
                double d2 = particle.velocity.get().getMagnitude();
                ImmutableVector2D immutableVector2D = particle.velocity.get().times(3.0).plus(this.velocity).getInstanceOfMagnitude(d2);
                particle.velocity.set(immutableVector2D);
                new FreeParticleStrategy(this.model).randomWalk(particle, d);
            } else {
                particle.velocity.set(this.velocity);
                particle.stepInTime(ImmutableVector2D.ZERO, d);
            }
            if (!this.model.solution.shape.get().getBounds2D().contains(particle.getShape().getBounds2D())) {
                this.model.preventFromLeavingBeaker(particle);
            }
        }
    }
}

