/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Crystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystalDissolve;
import java.util.IdentityHashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DissolveDisconnectedCrystals {
    private final MicroModel model;
    private final IdentityHashMap<Crystal, Integer> numberStepsDisconnected = new IdentityHashMap();
    private static final Logger LOGGER = LoggingUtils.getLogger(DissolveDisconnectedCrystals.class.getCanonicalName());

    public DissolveDisconnectedCrystals(MicroModel microModel) {
        this.model = microModel;
    }

    public <T extends Particle, U extends Crystal<T>> void apply(ItemList<U> itemList) {
        for (Crystal crystal : itemList.toList()) {
            if (crystal.isConnected()) {
                this.numberStepsDisconnected.remove(crystal);
                continue;
            }
            int n = this.numberStepsDisconnected.containsKey(crystal) ? this.numberStepsDisconnected.get(crystal) + 1 : 1;
            this.numberStepsDisconnected.put(crystal, n);
            if (n <= 30) continue;
            LOGGER.fine("Crystal disconnected for " + n + " steps, dissolving...");
            new CrystalDissolve(this.model).dissolve(crystal, crystal.getConstituents().toList());
            itemList.remove(crystal);
        }
        if (this.numberStepsDisconnected.keySet().size() > 100) {
            this.numberStepsDisconnected.clear();
        }
    }
}

