/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Crystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystalDissolve;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.UpdateStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrystalStrategy
extends UpdateStrategy {
    public final CrystalDissolve crystalDissolve;
    private final ItemList<? extends Crystal> crystals;
    private final ObservableProperty<Boolean> saturated;

    public CrystalStrategy(MicroModel microModel, ItemList<? extends Crystal> itemList, ObservableProperty<Boolean> observableProperty) {
        super(microModel);
        this.crystals = itemList;
        this.saturated = observableProperty;
        this.crystalDissolve = new CrystalDissolve(microModel);
    }

    @Override
    public void stepInTime(Particle particle, double d) {
        boolean bl;
        double d2;
        boolean bl2;
        Crystal crystal = (Crystal)particle;
        if (this.solution.shape.get().contains(crystal.getShape().getBounds2D())) {
            crystal.setSubmerged();
        }
        if (bl2 = this.model.isAnyPartUnderwater(crystal)) {
            crystal.velocity.set(new ImmutableVector2D(0.0, -1.0).times(2.5E-10));
        }
        this.model.boundToBeakerBottom(crystal);
        if (!crystal.isUnderwaterTimeRecorded() && !this.model.isCrystalTotallyAboveTheWater(crystal)) {
            crystal.setUnderwater(this.model.getTime());
        }
        crystal.stepInTime(this.model.getExternalForce(bl2).times(1.0E-10), d);
        this.model.boundToBeakerBottom(crystal);
        boolean bl3 = false;
        if (crystal.isUnderwaterTimeRecorded() && (d2 = this.model.getTime() - crystal.getUnderWaterTime()) > 0.5) {
            bl3 = true;
        }
        this.model.preventFromLeavingBeaker(crystal);
        boolean bl4 = bl = (Double)this.model.evaporationRate.get() > 0.0 && this.saturated.get() != false;
        if (bl3 || bl) {
            this.crystalDissolve.dissolve(this.crystals, crystal, this.saturated);
        }
    }
}

