/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.calciumchloride;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.IFormulaUnit;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeParticleFormulaUnit<T extends Particle>
implements IFormulaUnit {
    private final T a;
    private final T b;
    private final T c;

    public ThreeParticleFormulaUnit(T t, T t2, T t3) {
        this.a = t;
        this.b = t2;
        this.c = t3;
    }

    @Override
    public double getDistance() {
        double d = ((Particle)this.a).getDistance((Particle)this.b);
        double d2 = ((Particle)this.b).getDistance((Particle)this.c);
        double d3 = ((Particle)this.a).getDistance((Particle)this.c);
        return (d + d2 + d3) / 3.0;
    }

    @Override
    public void moveTogether(double d) {
        ImmutableVector2D immutableVector2D = ((Particle)this.a).getPosition().plus(((Particle)this.b).getPosition()).plus(((Particle)this.c).getPosition()).times(0.3333333333333333);
        this.moveToCentroid((Particle)this.a, immutableVector2D, d);
        this.moveToCentroid((Particle)this.b, immutableVector2D, d);
        this.moveToCentroid((Particle)this.c, immutableVector2D, d);
    }

    private void moveToCentroid(Particle particle, ImmutableVector2D immutableVector2D, double d) {
        ImmutableVector2D immutableVector2D2 = new ImmutableVector2D(particle.getPosition(), immutableVector2D).getNormalizedInstance();
        ImmutableVector2D immutableVector2D3 = immutableVector2D2.times(6.0E-10);
        particle.velocity.set(immutableVector2D3);
        particle.stepInTime(ImmutableVector2D.ZERO, d);
    }

    @Override
    public ArrayList<T> getParticles() {
        return new ArrayList<T>(){
            {
                this.add(ThreeParticleFormulaUnit.this.a);
                this.add(ThreeParticleFormulaUnit.this.b);
                this.add(ThreeParticleFormulaUnit.this.c);
            }
        };
    }
}

