/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.calciumchloride;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Crystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Formula;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalciumChlorideCrystal
extends Crystal<SphericalParticle> {
    public CalciumChlorideCrystal(ImmutableVector2D immutableVector2D, double d) {
        super(Formula.CALCIUM_CHLORIDE, immutableVector2D, new SphericalParticle.Calcium().radius + new SphericalParticle.Chloride().radius, d);
    }

    @Override
    public SphericalParticle createPartner(SphericalParticle sphericalParticle) {
        return sphericalParticle instanceof SphericalParticle.Calcium ? new SphericalParticle.Chloride() : new SphericalParticle.Calcium();
    }

    @Override
    protected SphericalParticle createConstituentParticle(Class<? extends Particle> clazz) {
        return clazz == SphericalParticle.Calcium.class ? new SphericalParticle.Calcium() : new SphericalParticle.Chloride();
    }

    @Override
    public ImmutableVector2D[] getPossibleDirections(Constituent<SphericalParticle> constituent) {
        if (constituent.particle instanceof SphericalParticle.Chloride) {
            if (this.isOccupied(constituent.relativePosition.plus(this.northUnitVector))) {
                return new ImmutableVector2D[]{this.southUnitVector};
            }
            if (this.isOccupied(constituent.relativePosition.plus(this.southUnitVector))) {
                return new ImmutableVector2D[]{this.northUnitVector};
            }
            if (this.isOccupied(constituent.relativePosition.plus(this.eastUnitVector))) {
                return new ImmutableVector2D[]{this.westUnitVector};
            }
            if (this.isOccupied(constituent.relativePosition.plus(this.westUnitVector))) {
                return new ImmutableVector2D[]{this.eastUnitVector};
            }
        }
        return super.getPossibleDirections(constituent);
    }
}

