/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.macro.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.event.Notifier;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.CompositeDoubleProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.LessThan;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.piccolophet.nodes.conductivitytester.IConductivityTester;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.AirborneCrystalMoles;
import edu.colorado.phet.sugarandsaltsolutions.common.model.BeakerDimension;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ConductivityTester;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.colorado.phet.sugarandsaltsolutions.macro.model.MacroCrystal;
import edu.colorado.phet.sugarandsaltsolutions.macro.model.MacroSalt;
import edu.colorado.phet.sugarandsaltsolutions.macro.model.MacroSaltShaker;
import edu.colorado.phet.sugarandsaltsolutions.macro.model.MacroSugar;
import edu.colorado.phet.sugarandsaltsolutions.macro.model.SoluteModel;
import edu.colorado.phet.sugarandsaltsolutions.macro.view.MacroSugarDispenser;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroModel
extends SugarAndSaltSolutionModel {
    public final ConductivityTester conductivityTester;
    public final ArrayList<MacroSugar> sugarList = new ArrayList();
    public final Notifier<MacroSugar> sugarAdded = new Notifier();
    public final ArrayList<MacroSalt> saltList = new ArrayList();
    public final Notifier<MacroSalt> saltAdded = new Notifier();
    public final SoluteModel salt;
    public final SoluteModel sugar;
    public final CompositeDoubleProperty solidVolume;
    public final CompositeDoubleProperty saltConcentration;
    public final CompositeDoubleProperty sugarConcentration;
    protected final CompositeDoubleProperty airborneSaltGrams;
    protected final CompositeDoubleProperty airborneSugarGrams;
    private final ImmutableVector2D gravity = new ImmutableVector2D(0.0, -9.8);
    public final ObservableProperty<Boolean> anySolutes;

    public MacroModel() {
        super(new ConstantDtClock(30.0), new BeakerDimension(0.2), 5.0E-4, 0.011746031746031754, 0.026349206349206344, 1.0);
        this.salt = new SoluteModel(this.waterVolume, 6140.0, 2.699E-5, 58.4425);
        this.sugar = new SoluteModel(this.waterVolume, 5850.0, 2.157E-4, 342.23134);
        this.anySolutes = this.salt.moles.greaterThan(0.0).or(this.sugar.moles.greaterThan(0.0));
        this.solidVolume = this.salt.solidVolume.plus(this.sugar.solidVolume);
        this.saltConcentration = this.salt.molesDissolved.dividedBy(this.solution.volume);
        this.sugarConcentration = this.sugar.molesDissolved.dividedBy(this.solution.volume);
        this.airborneSaltGrams = new AirborneCrystalMoles(this.saltList).times(this.salt.gramsPerMole);
        this.airborneSugarGrams = new AirborneCrystalMoles(this.sugarList).times(this.sugar.gramsPerMole);
        LessThan lessThan = this.salt.grams.plus(this.airborneSaltGrams).lessThan(100.0);
        LessThan lessThan2 = this.sugar.grams.plus(this.airborneSugarGrams).lessThan(100.0);
        this.dispensers.add(new MacroSaltShaker(this.beaker.getCenterX(), this.beaker.getTopY() + this.beaker.getHeight() * 0.5, this.beaker, (ObservableProperty<Boolean>)lessThan, SugarAndSaltSolutionsResources.Strings.SALT, this.distanceScale, (ObservableProperty<DispenserType>)this.dispenserType, DispenserType.SALT, this));
        this.dispensers.add(new MacroSugarDispenser(this.beaker.getCenterX(), this.beaker.getTopY() + this.beaker.getHeight() * 0.5, this.beaker, (ObservableProperty<Boolean>)lessThan2, SugarAndSaltSolutionsResources.Strings.SUGAR, this.distanceScale, (ObservableProperty<DispenserType>)this.dispenserType, DispenserType.SUGAR, this));
        this.conductivityTester = new ConductivityTester(this.beaker.getWidth(), this.beaker.getHeight());
        this.conductivityTester.addConductivityTesterChangeListener(new IConductivityTester.ConductivityTesterChangeListener(){

            public void brightnessChanged() {
            }

            public void positiveProbeLocationChanged() {
                MacroModel.this.updateConductivityTesterBrightness();
            }

            public void negativeProbeLocationChanged() {
                MacroModel.this.updateConductivityTesterBrightness();
            }

            public void locationChanged() {
                MacroModel.this.updateConductivityTesterBrightness();
            }
        });
        new RichSimpleObserver(){

            public void update() {
                MacroModel.this.updateConductivityTesterBrightness();
            }
        }.observe(this.saltConcentration, this.solution.shape, this.outputWater);
    }

    protected void crystalAbsorbed(MacroCrystal macroCrystal) {
        if (macroCrystal instanceof MacroSalt) {
            this.salt.moles.set((Double)this.salt.moles.get() + macroCrystal.getMoles());
        } else if (macroCrystal instanceof MacroSugar) {
            this.sugar.moles.set((Double)this.sugar.moles.get() + macroCrystal.getMoles());
        }
    }

    public void removeSaltAndSugar() {
        this.removeSalt();
        this.removeSugar();
    }

    public final void removeSalt() {
        this.removeCrystals(this.saltList, this.saltList);
        this.salt.moles.set(0.0);
    }

    public final void removeSugar() {
        this.removeCrystals(this.sugarList, this.sugarList);
        this.sugar.moles.set(0.0);
    }

    public void addMacroSugar(MacroSugar macroSugar) {
        this.sugarList.add(macroSugar);
        this.sugarAdded.updateListeners(macroSugar);
    }

    public void addMacroSalt(MacroSalt macroSalt) {
        this.saltList.add(macroSalt);
        this.saltAdded.updateListeners(macroSalt);
    }

    private void updateCrystals(double d, ArrayList<? extends MacroCrystal> arrayList) {
        ArrayList<MacroCrystal> arrayList2 = new ArrayList<MacroCrystal>();
        for (MacroCrystal macroCrystal : arrayList) {
            ImmutableVector2D immutableVector2D = macroCrystal.position.get();
            macroCrystal.stepInTime(this.gravity.times(macroCrystal.mass), d / 10.0, this.beaker.getLeftWall(), this.beaker.getRightWall(), this.beaker.getFloor(), new Line2D.Double(this.beaker.getFloor().getX1(), 0.0, this.beaker.getFloor().getX2(), 0.0));
            if (new Line2D.Double(immutableVector2D.toPoint2D(), macroCrystal.position.get().toPoint2D()).intersects(this.solution.shape.get().getBounds2D())) {
                arrayList2.add(macroCrystal);
                continue;
            }
            if (!macroCrystal.isLanded()) continue;
            arrayList2.add(macroCrystal);
        }
        this.removeCrystals(arrayList, arrayList2);
        for (MacroCrystal macroCrystal : arrayList2) {
            this.crystalAbsorbed(macroCrystal);
        }
        this.airborneSaltGrams.notifyIfChanged();
        this.airborneSugarGrams.notifyIfChanged();
    }

    private boolean isProbeTouchingWaterThatMightHaveSalt(ImmutableRectangle2D immutableRectangle2D) {
        Rectangle2D rectangle2D = this.solution.shape.get().getBounds2D();
        Rectangle2D rectangle2D2 = immutableRectangle2D.toRectangle2D();
        return rectangle2D.intersects(immutableRectangle2D.toRectangle2D()) || ((Shape)this.outputWater.get()).getBounds2D().intersects(rectangle2D2);
    }

    protected void updateConductivityTesterBrightness() {
        Rectangle2D rectangle2D = this.solution.shape.get().getBounds2D();
        boolean bl = this.isProbeTouchingWaterThatMightHaveSalt(this.conductivityTester.getPositiveProbeRegion()) && this.isProbeTouchingWaterThatMightHaveSalt(this.conductivityTester.getNegativeProbeRegion());
        boolean bl2 = this.conductivityTester.getBatteryRegion() != null && rectangle2D.intersects(this.conductivityTester.getBatteryRegion().getBounds2D());
        boolean bl3 = this.conductivityTester.getBulbRegion() != null && rectangle2D.intersects(this.conductivityTester.getBulbRegion().getBounds2D());
        boolean bl4 = (bl2 || bl3) && (Double)this.saltConcentration.get() > 0.0;
        this.conductivityTester.brightness.set(bl && !bl4 ? MathUtil.clamp(0.0, (Double)this.saltConcentration.get() * 1.62E-4, 1.0) : 0.0);
        this.conductivityTester.shortCircuited.set(bl4);
    }

    public ObservableProperty<Boolean> getAnySolutes() {
        return this.anySolutes;
    }

    @Override
    public void reset() {
        super.reset();
        this.removeSaltAndSugar();
        this.conductivityTester.reset();
    }

    public ObservableProperty<Boolean> isAnySaltToRemove() {
        return this.salt.moles.greaterThan(0.0);
    }

    public ObservableProperty<Boolean> isAnySugarToRemove() {
        return this.sugar.moles.greaterThan(0.0);
    }

    protected void waterDrained(double d, double d2, double d3) {
        this.updateConcentration(d, d2, this.salt.moles);
        this.updateConcentration(d, d3, this.sugar.moles);
    }

    private void updateConcentration(double d, double d2, SettableProperty<Double> settableProperty) {
        double d3 = d2 * d;
        settableProperty.set((Double)settableProperty.get() - d3);
    }

    @Override
    protected double updateModel(double d) {
        double d2 = (Double)this.saltConcentration.get();
        double d3 = (Double)this.sugarConcentration.get();
        double d4 = super.updateModel(d);
        if (d4 > 0.0) {
            this.waterDrained(d4, d2, d3);
        }
        this.updateCrystals(d, this.saltList);
        this.updateCrystals(d, this.sugarList);
        return d4;
    }

    private void removeCrystals(ArrayList<? extends MacroCrystal> arrayList, ArrayList<? extends MacroCrystal> arrayList2) {
        for (MacroCrystal macroCrystal : new ArrayList<MacroCrystal>(arrayList2)) {
            macroCrystal.remove();
            arrayList.remove(macroCrystal);
        }
    }
}

