/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Beaker;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Units;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeakerNodeWithTicks
extends BeakerNode {
    public BeakerNodeWithTicks(ModelViewTransform modelViewTransform, Beaker beaker, boolean bl, final Property<Boolean> property) {
        super(modelViewTransform, beaker);
        double d = modelViewTransform.modelToViewX(beaker.getX() - beaker.getWallThickness() / 2.0);
        double d2 = new Function.LinearFunction(0.0, 0.002, 0.0, 1.0).evaluate(beaker.getMaxFluidVolume());
        double d3 = 5.0E-4 * d2;
        for (double d4 = 0.0; d4 <= 0.002 * d2; d4 += d3) {
            double d5 = 5.0;
            double d6 = modelViewTransform.modelToViewY(beaker.getHeightForVolume(d4) + beaker.getY());
            Line2D.Double double_ = new Line2D.Double(d - d5, d6, d, d6);
            this.addChild(new PhetPPath(double_, new BasicStroke(2.0f), Color.white){
                {
                    super(shape, stroke, paint);
                    property.addObserver(new VoidFunction1<Boolean>(){

                        @Override
                        public void apply(Boolean bl) {
                            this.setStrokePaint(bl != false ? Color.black : Color.white);
                        }
                    });
                }
            });
        }
        for (double d7 : new double[]{0.0, 0.001 * d2, 0.002 * d2}) {
            double d8 = 10.0;
            double d9 = modelViewTransform.modelToViewY(beaker.getHeightForVolume(d7) + beaker.getY());
            PhetPPath phetPPath = new PhetPPath(new Line2D.Double(d - d8, d9, d, d9), new BasicStroke(4.0f), Color.white){
                {
                    super(shape, stroke, paint);
                    property.addObserver(new VoidFunction1<Boolean>(){

                        @Override
                        public void apply(Boolean bl) {
                            this.setStrokePaint(bl != false ? Color.black : Color.white);
                        }
                    });
                }
            };
            this.addChild(phetPPath);
            if (!bl) continue;
            PNode pNode = this.createLabelNode(d7, property);
            pNode.setOffset(phetPPath.getFullBounds().getX() - pNode.getFullBounds().getWidth(), phetPPath.getFullBounds().getCenterY() - pNode.getFullBounds().getHeight() / 2.0);
            this.addChild(pNode);
        }
    }

    private PNode createLabelNode(double d, final Property<Boolean> property) {
        final PhetFont phetFont = new PhetFont(20);
        if (d == 0.0 || d > 1.0E-20) {
            double d2 = Units.metersCubedToLiters(d);
            String string = d2 < 1.0E-6 && d2 > 0.0 ? "" : new DecimalFormat("0").format(d2);
            return new PText(MessageFormat.format(SugarAndSaltSolutionsResources.Strings.PATTERN__BEAKER_TICK_LABEL, string)){
                {
                    super(string);
                    property.addObserver(new VoidFunction1<Boolean>(){

                        @Override
                        public void apply(Boolean bl) {
                            this.setTextPaint(bl != false ? Color.black : Color.white);
                        }
                    });
                    this.setFont(phetFont);
                }
            };
        }
        String string = BeakerNodeWithTicks.volumeToHTMLString(d, "0");
        return new HTMLNode(MessageFormat.format(SugarAndSaltSolutionsResources.Strings.PATTERN__BEAKER_TICK_LABEL, string)){
            {
                super(string);
                property.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setHTMLColor(bl != false ? Color.black : Color.white);
                    }
                });
                this.setFont(phetFont);
            }
        };
    }

    public static String volumeToHTMLString(double d, String string) {
        double d2 = Units.metersCubedToLiters(d);
        int n = -23;
        double d3 = d2 / Math.pow(10.0, n);
        if (d2 == 0.0) {
            return "0";
        }
        return new DecimalFormat(string).format(d3) + "x10<sup>" + n + "</sup>";
    }
}

