/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view;

import edu.colorado.phet.common.phetcommon.model.property.Not;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.faucet.FaucetNode;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.ToolboxCanvas;
import edu.colorado.phet.sugarandsaltsolutions.GlobalState;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Dispenser;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerNodeWithTicks;
import edu.colorado.phet.sugarandsaltsolutions.common.view.DrainFaucetNodeLocationDebugger;
import edu.colorado.phet.sugarandsaltsolutions.common.view.EvaporationSlider;
import edu.colorado.phet.sugarandsaltsolutions.common.view.FaucetMetrics;
import edu.colorado.phet.sugarandsaltsolutions.common.view.ICanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SolutionNode;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SugarAndSaltSolutionsCanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SugarAndSaltSolutionsResetAllButtonNode;
import edu.colorado.phet.sugarandsaltsolutions.common.view.WaterNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class BeakerAndShakerCanvas
extends SugarAndSaltSolutionsCanvas
implements ToolboxCanvas,
ICanvas {
    public static final Color WATER_COLOR = new Color(179, 239, 243);
    public static final Font CONTROL_FONT = new PhetFont(16, true);
    public static final Font TITLE_FONT = new PhetFont(18, true);
    protected final PDimension stageSize;
    protected final ModelViewTransform transform;
    public static final Dimension canvasSize = new Dimension(1008, 676);
    protected final PNode behindShakerNode;
    public final PNode submergedInWaterNode = new PNode();
    public static final Color BUTTON_COLOR = new Color(255, 153, 0);
    protected final FaucetNode drainFaucetNode;
    protected final EvaporationSlider evaporationSlider;
    private final boolean debug = false;
    private final boolean debugVisibleBounds = false;

    public BeakerAndShakerCanvas(final SugarAndSaltSolutionModel sugarAndSaltSolutionModel, GlobalState globalState, final ModelViewTransform modelViewTransform, boolean bl, boolean bl2) {
        this.stageSize = new PDimension(BeakerAndShakerCanvas.canvasSize.width, (int)((double)BeakerAndShakerCanvas.canvasSize.width / sugarAndSaltSolutionModel.visibleRegion.width * sugarAndSaltSolutionModel.visibleRegion.height));
        this.transform = modelViewTransform;
        globalState.colorScheme.backgroundColorSet.color.addObserver(new VoidFunction1<Color>(){

            @Override
            public void apply(Color color) {
                BeakerAndShakerCanvas.this.setBackground(color);
            }
        });
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, this.stageSize));
        this.addChild(new SugarAndSaltSolutionsResetAllButtonNode(this.stageSize.getWidth(), this.stageSize.getHeight(), new VoidFunction0(){

            public void apply() {
                sugarAndSaltSolutionModel.reset();
            }
        }));
        this.addChild(new WaterNode(modelViewTransform, sugarAndSaltSolutionModel.inputWater));
        this.addChild(new WaterNode(modelViewTransform, sugarAndSaltSolutionModel.outputWater));
        FaucetNode faucetNode = new FaucetNode(sugarAndSaltSolutionModel.inputFlowRate, sugarAndSaltSolutionModel.clockRunning.and(Not.not(sugarAndSaltSolutionModel.beakerFull)), 10000.0, true){
            {
                this.setOffset(50.0, 10.0);
            }
        };
        this.addChild(faucetNode);
        sugarAndSaltSolutionModel.setInputFaucetMetrics(new FaucetMetrics(modelViewTransform, sugarAndSaltSolutionModel, this.rootNode, faucetNode));
        this.drainFaucetNode = new FaucetNode(sugarAndSaltSolutionModel.outputFlowRate, sugarAndSaltSolutionModel.clockRunning.and(sugarAndSaltSolutionModel.lowerFaucetCanDrain), 12.0, true){
            {
                super(property, observableProperty, d, bl);
                Point2D point2D = sugarAndSaltSolutionModel.beaker.getOutputFaucetAttachmentPoint();
                Point2D point2D2 = modelViewTransform.modelToView(point2D);
                this.setOffset(point2D2.getX() + 7.0 + 12.0, point2D2.getY() - this.getFullBounds().getHeight() * 0.8);
            }
        };
        this.addChild(this.drainFaucetNode);
        Rectangle2D.Double double_ = sugarAndSaltSolutionModel.beaker.getWaterShape(0.0, sugarAndSaltSolutionModel.beaker.getMaxFluidVolume());
        sugarAndSaltSolutionModel.setDrainFaucetMetrics(new FaucetMetrics(modelViewTransform, sugarAndSaltSolutionModel, this.rootNode, this.drainFaucetNode).clampInputWithinFluid(double_.getMaxX() - double_.getWidth() * 0.02));
        this.behindShakerNode = new PNode();
        this.addChild(this.behindShakerNode);
        for (Dispenser dispenser : sugarAndSaltSolutionModel.dispensers) {
            this.submergedInWaterNode.addChild(dispenser.createNode(modelViewTransform, bl, sugarAndSaltSolutionModel.dragConstraint));
        }
        this.addChild(new BeakerNodeWithTicks(modelViewTransform, sugarAndSaltSolutionModel.beaker, bl2, globalState.colorScheme.whiteBackground));
        this.addChild(new SolutionNode(modelViewTransform, sugarAndSaltSolutionModel.solution, WATER_COLOR));
        this.addChild(this.submergedInWaterNode);
        this.addChild(new SolutionNode(modelViewTransform, sugarAndSaltSolutionModel.solution, new Color(WATER_COLOR.getRed(), WATER_COLOR.getGreen(), WATER_COLOR.getBlue(), 128)));
        this.evaporationSlider = new EvaporationSlider(sugarAndSaltSolutionModel.evaporationRate, sugarAndSaltSolutionModel.waterVolume, sugarAndSaltSolutionModel.clockRunning){
            {
                super(settableProperty, doubleProperty, observableProperty);
                Point2D point2D = BeakerAndShakerCanvas.this.transform.modelToView(0.0, -sugarAndSaltSolutionModel.beaker.getWallThickness() / 2.0);
                this.setOffset(point2D.getX() - this.getFullBounds().getWidth() / 2.0, point2D.getY() + 5.0);
            }
        };
        this.behindShakerNode.addChild(this.evaporationSlider);
        this.addChild(new DrainFaucetNodeLocationDebugger(modelViewTransform, sugarAndSaltSolutionModel));
    }

    public ModelViewTransform getModelViewTransform() {
        return this.transform;
    }
}

