/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics.transforms;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ModelViewTransform {
    private AffineTransform transform;

    private ModelViewTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public static ModelViewTransform createOffsetScaleMapping(Point2D point2D, double d, double d2) {
        return new ModelViewTransform(new AffineTransform(d, 0.0, 0.0, d2, point2D.getX(), point2D.getY()));
    }

    public static ModelViewTransform createSinglePointScaleMapping(Point2D point2D, Point2D point2D2, double d, double d2) {
        double d3 = point2D2.getX() - point2D.getX() * d;
        double d4 = point2D2.getY() - point2D.getY() * d2;
        return ModelViewTransform.createOffsetScaleMapping(new Point2D.Double(d3, d4), d, d2);
    }

    public static ModelViewTransform createSinglePointScaleMapping(Point2D point2D, Point2D point2D2, double d) {
        return ModelViewTransform.createSinglePointScaleMapping(point2D, point2D2, d, d);
    }

    public static ModelViewTransform createRectangleInvertedYMapping(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D2.getWidth() / rectangle2D.getWidth();
        double d2 = rectangle2D2.getX() - d * rectangle2D.getX();
        double d3 = -rectangle2D2.getHeight() / rectangle2D.getHeight();
        double d4 = rectangle2D2.getY() - d3 * rectangle2D.getMaxY();
        return new ModelViewTransform(new AffineTransform(d, 0.0, 0.0, d3, d2, d4));
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public Point2D modelToView(Point2D point2D) {
        return this.transform.transform(point2D, null);
    }

    public ImmutableVector2D modelToView(ImmutableVector2D immutableVector2D) {
        return new ImmutableVector2D(this.transform.transform(immutableVector2D.toPoint2D(), null));
    }

    public Point2D modelToViewDelta(Point2D point2D) {
        return this.transform.deltaTransform(point2D, null);
    }

    public ImmutableVector2D modelToViewDelta(ImmutableVector2D immutableVector2D) {
        return new ImmutableVector2D(this.modelToViewDelta(immutableVector2D.toPoint2D()));
    }

    public Shape modelToView(Shape shape) {
        return this.transform.createTransformedShape(shape);
    }

    public Dimension2D modelToViewSize(Dimension2D dimension2D) {
        Rectangle2D rectangle2D = this.modelToView(new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight())).getBounds2D();
        return new Dimension2DDouble(rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public double modelToViewX(double d) {
        return this.modelToView(new Point2D.Double(d, 0.0)).getX();
    }

    public double modelToViewY(double d) {
        return this.modelToView(0.0, d).getY();
    }

    public Point2D modelToView(double d, double d2) {
        return this.modelToView(new Point2D.Double(d, d2));
    }

    public double modelToViewDeltaX(double d) {
        return this.modelToViewDelta(new Point2D.Double(d, 0.0)).getX();
    }

    public Point2D viewToModel(Point2D point2D) {
        return this.getInverseTransform().transform(point2D, null);
    }

    public ImmutableVector2D viewToModel(ImmutableVector2D immutableVector2D) {
        return new ImmutableVector2D(this.viewToModel(immutableVector2D.toPoint2D()));
    }

    public Point2D viewToModelDelta(Point2D point2D) {
        return this.getInverseTransform().deltaTransform(point2D, null);
    }

    public ImmutableVector2D viewToModelDelta(ImmutableVector2D immutableVector2D) {
        return new ImmutableVector2D(this.viewToModelDelta(immutableVector2D.toPoint2D()));
    }

    public Point2D viewToModel(double d, double d2) {
        return this.viewToModel(new Point2D.Double(d, d2));
    }

    public Dimension2D viewToModelDelta(Dimension2D dimension2D) {
        Point2D point2D = this.viewToModelDelta(new Point2D.Double(dimension2D.getWidth(), dimension2D.getHeight()));
        return new Dimension2DDouble(point2D.getX(), point2D.getY());
    }

    protected AffineTransform getInverseTransform() {
        try {
            return this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
    }

    public Shape viewToModel(Shape shape) {
        return this.getInverseTransform().createTransformedShape(shape);
    }

    public double viewToModelDeltaX(double d) {
        return this.viewToModelDelta(new Point2D.Double(d, 0.0)).getX();
    }

    public double viewToModelDeltaY(double d) {
        return this.viewToModelDelta(new Point2D.Double(0.0, d)).getY();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.transform.equals(((ModelViewTransform)object).transform);
    }

    public int hashCode() {
        return this.transform.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.transform.toString();
    }
}

