/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.AWTSplashWindow;
import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.KSUCreditsWindow;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.statistics.StatisticsManager;
import edu.colorado.phet.common.phetcommon.updates.AutomaticUpdatesManager;
import edu.colorado.phet.common.phetcommon.updates.ManualUpdatesManager;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PhetApplicationLauncher {
    private AWTSplashWindow splashWindow;
    private Frame splashWindowOwner;

    private void showSplashWindow(String string) {
        if (this.splashWindow == null) {
            this.splashWindowOwner = new Frame();
            this.splashWindow = new AWTSplashWindow(this.splashWindowOwner, string);
            this.splashWindow.setVisible(true);
        }
    }

    private void disposeSplashWindow() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
            this.splashWindow = null;
            this.splashWindowOwner.dispose();
            this.splashWindowOwner = null;
        }
    }

    private void showKSUCredits(PhetApplicationConfig phetApplicationConfig, Frame frame) {
        final KSUCreditsWindow kSUCreditsWindow = new KSUCreditsWindow(frame);
        SwingUtils.centerInParent(kSUCreditsWindow);
        kSUCreditsWindow.setVisible(true);
        Timer timer = new Timer(4000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                kSUCreditsWindow.dispose();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private boolean shouldShowKSUCredits(PhetApplicationConfig phetApplicationConfig) {
        String string = phetApplicationConfig.getResourceLoader().getLocalizedProperties().getString("ksu.credits", false);
        return !string.equals("ksu.credits");
    }

    public void launchSim(String[] stringArray, String string, Class clazz) {
        this.launchSim(stringArray, string, new ReflectionApplicationConstructor(clazz));
    }

    public void launchSim(String[] stringArray, String string, String string2, Class clazz) {
        this.launchSim(stringArray, string, string2, new ReflectionApplicationConstructor(clazz));
    }

    public void launchSim(String[] stringArray, String string, ApplicationConstructor applicationConstructor) {
        this.launchSim(new PhetApplicationConfig(stringArray, string), applicationConstructor);
    }

    public void launchSim(String[] stringArray, String string, String string2, ApplicationConstructor applicationConstructor) {
        this.launchSim(new PhetApplicationConfig(stringArray, string, string2), applicationConstructor);
    }

    public void launchSim(PhetApplicationConfig phetApplicationConfig, Class clazz) {
        this.launchSim(phetApplicationConfig, new ReflectionApplicationConstructor(clazz));
    }

    public void launchSim(final PhetApplicationConfig phetApplicationConfig, final ApplicationConstructor applicationConstructor) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    phetApplicationConfig.getLookAndFeel().initLookAndFeel();
                    new JSpinner();
                    if (applicationConstructor != null) {
                        PhetApplicationLauncher.this.showSplashWindow(phetApplicationConfig.getName());
                        PhetApplication phetApplication = applicationConstructor.getApplication(phetApplicationConfig);
                        phetApplication.startApplication();
                        PhetApplicationLauncher.this.disposeSplashWindow();
                        if (PhetApplicationLauncher.this.shouldShowKSUCredits(phetApplicationConfig)) {
                            PhetApplicationLauncher.this.showKSUCredits(phetApplicationConfig, phetApplication.getPhetFrame());
                        }
                        if (phetApplication.getSimInfo().getVersion().getMajorAsInt() >= 1) {
                            StatisticsManager.initInstance(phetApplication).start();
                            AutomaticUpdatesManager.initInstance(phetApplication).start();
                            ManualUpdatesManager.initInstance(phetApplication);
                        }
                    } else {
                        new RuntimeException("No applicationconstructor specified").printStackTrace();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static class ReflectionApplicationConstructor
    implements ApplicationConstructor {
        private Class phetApplicationClass;

        public ReflectionApplicationConstructor(Class clazz) {
            this.phetApplicationClass = clazz;
        }

        public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
            try {
                return (PhetApplication)this.phetApplicationClass.getConstructor(phetApplicationConfig.getClass()).newInstance(phetApplicationConfig);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

