/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.statesofmatter.StatesOfMatterResources;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.view.StoveControlSliderNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.Ellipse2D;

public class StoveNode
extends PNode {
    private static final Color BASE_COLOR = new Color(159, 182, 205);
    private static DoubleRange heatRange = new DoubleRange(-1.0, 1.0);
    private final PImage m_fireImage;
    private final PImage m_iceImage;
    private final MultipleParticleModel m_model;
    private final Property<Double> m_heat = new Property<Double>(0.0);
    private final PNode m_burner;

    public StoveNode(MultipleParticleModel multipleParticleModel) {
        this.m_model = multipleParticleModel;
        if (this.m_model != null) {
            this.m_model.addListener(new MultipleParticleModel.Adapter(){

                public void resetOccurred() {
                    StoveNode.this.m_heat.set(0.0);
                }

                public void moleculeTypeChanged() {
                    StoveNode.this.m_heat.set(0.0);
                }

                public void containerExplodedStateChanged(boolean bl) {
                    StoveNode.this.m_heat.set(0.0);
                }
            });
        }
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(){
            {
                double d = 200.0;
                this.moveTo(0.0, 0.0);
                this.curveTo(0.0, 12.5, 250.0, 12.5, 250.0, 0.0);
                this.lineTo((250.0 + d) / 2.0, 187.5);
                this.curveTo((250.0 + d) / 2.0, 200.0, (250.0 - d) / 2.0, 200.0, (250.0 - d) / 2.0, 187.5);
                this.lineTo(0.0, 0.0);
                this.closePath();
            }
        };
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, ColorUtils.brighterColor(BASE_COLOR, 0.5), 250.0f, 0.0f, ColorUtils.darkerColor(BASE_COLOR, 0.5));
        this.m_burner = new PhetPPath(doubleGeneralPath.getGeneralPath(), gradientPaint, new BasicStroke(1.0f), Color.BLACK);
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 250.0, 25.0);
        GradientPaint gradientPaint2 = new GradientPaint(0.0f, 0.0f, ColorUtils.darkerColor(BASE_COLOR, 0.25), 250.0f, 0.0f, ColorUtils.brighterColor(BASE_COLOR, 0.5));
        PhetPPath phetPPath = new PhetPPath(double_, gradientPaint2, new BasicStroke(1.0f), Color.LIGHT_GRAY);
        StoveControlSliderNode stoveControlSliderNode = new StoveControlSliderNode(this.m_heat){
            {
                double d = 200.0;
                double d2 = 150.0;
                double d3 = Math.min(d / this.getFullBoundsReference().width, d2 / this.getFullBoundsReference().height);
                this.setScale(d3);
            }
        };
        this.m_fireImage = StatesOfMatterResources.getImageNode("flame.png");
        this.m_fireImage.setScale(200.0 / this.m_fireImage.getFullBoundsReference().getWidth());
        this.m_iceImage = StatesOfMatterResources.getImageNode("ice-cube-stack.png");
        this.m_iceImage.setScale(200.0 / this.m_iceImage.getFullBoundsReference().getWidth());
        this.addChild(phetPPath);
        this.addChild(this.m_fireImage);
        this.addChild(this.m_iceImage);
        this.addChild(this.m_burner);
        this.addChild(stoveControlSliderNode);
        phetPPath.setOffset(0.0, -phetPPath.getFullBoundsReference().height / 2.0);
        stoveControlSliderNode.setOffset(125.0 - stoveControlSliderNode.getFullBoundsReference().width / 2.0, 93.75 - stoveControlSliderNode.getFullBoundsReference().height / 2.0 + phetPPath.getFullBoundsReference().height / 2.0);
        this.m_heat.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                StoveNode.this.update();
                if (StoveNode.this.m_model != null) {
                    StoveNode.this.m_model.setHeatingCoolingAmount(d);
                }
            }
        });
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                pInputEvent.getInputManager().setKeyboardFocus(pInputEvent.getPath());
            }

            public void keyPressed(PInputEvent pInputEvent) {
                double d = 50.0;
                switch (pInputEvent.getKeyCode()) {
                    case 38: 
                    case 224: {
                        StoveNode.this.m_heat.set(Math.min((Double)StoveNode.this.m_heat.get() + heatRange.getLength() / d, 1.0));
                        break;
                    }
                    case 40: 
                    case 225: {
                        StoveNode.this.m_heat.set(Math.max((Double)StoveNode.this.m_heat.get() - heatRange.getLength() / d, -1.0));
                        break;
                    }
                    case 10: 
                    case 27: 
                    case 48: 
                    case 96: {
                        StoveNode.this.m_heat.set(0.0);
                        break;
                    }
                }
            }
        });
        this.update();
    }

    private void update() {
        if (this.m_heat.get() > 0.0) {
            this.m_fireImage.setOffset(this.m_burner.getFullBoundsReference().width / 2.0 - this.m_fireImage.getFullBoundsReference().width / 2.0, -this.m_heat.get().doubleValue() * this.m_fireImage.getFullBoundsReference().height * 0.9);
            this.m_iceImage.setOffset(this.m_burner.getFullBoundsReference().width / 2.0 - this.m_iceImage.getFullBoundsReference().width / 2.0, 0.0);
        } else if (this.m_heat.get() <= 0.0) {
            this.m_iceImage.setOffset(this.m_burner.getFullBoundsReference().width / 2.0 - this.m_iceImage.getFullBoundsReference().width / 2.0, this.m_heat.get() * this.m_iceImage.getFullBoundsReference().height * 0.9);
            this.m_fireImage.setOffset(this.m_burner.getFullBoundsReference().width / 2.0 - this.m_fireImage.getFullBoundsReference().width / 2.0, 0.0);
        }
        this.m_iceImage.setVisible(this.m_heat.get() < 0.0);
        this.m_fireImage.setVisible(this.m_heat.get() > 0.0);
    }
}

