/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.solidliquidgas;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.FloatingClockControlNode;
import edu.colorado.phet.statesofmatter.StatesOfMatterConstants;
import edu.colorado.phet.statesofmatter.StatesOfMatterGlobalState;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.view.ModelViewTransform;
import edu.colorado.phet.statesofmatter.view.ParticleContainerNode;
import edu.colorado.phet.statesofmatter.view.StoveNode;
import edu.colorado.phet.statesofmatter.view.instruments.CompositeThermometerNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class SolidLiquidGasCanvas
extends PhetPCanvas
implements Resettable {
    private final MultipleParticleModel m_model;
    private final ParticleContainerNode m_particleContainer;
    private final CompositeThermometerNode m_thermometerNode;
    private final BooleanProperty m_clockRunning = new BooleanProperty(true);

    public SolidLiquidGasCanvas(final MultipleParticleModel multipleParticleModel) {
        this.m_model = multipleParticleModel;
        ModelViewTransform modelViewTransform = new ModelViewTransform(1.0, 1.0, 0.0, 0.0, false, true);
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new PDimension(23000.0, 17250.0)){

            protected AffineTransform getPreprocessedTransform() {
                return AffineTransform.getTranslateInstance((double)SolidLiquidGasCanvas.this.getWidth() * 0.3, (double)SolidLiquidGasCanvas.this.getHeight() * 0.72);
            }
        });
        this.m_model.addListener(new MultipleParticleModel.Adapter(){

            public void temperatureChanged() {
                SolidLiquidGasCanvas.this.updateThermometerTemperature();
            }
        });
        StatesOfMatterGlobalState.whiteBackground.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    SolidLiquidGasCanvas.this.setBackground(Color.WHITE);
                } else {
                    SolidLiquidGasCanvas.this.setBackground(StatesOfMatterConstants.CANVAS_BACKGROUND);
                }
            }
        });
        this.m_particleContainer = new ParticleContainerNode(this.m_model, modelViewTransform, false, false);
        this.addWorldChild(this.m_particleContainer);
        Rectangle2D rectangle2D = this.m_model.getParticleContainerRect();
        this.m_thermometerNode = new CompositeThermometerNode(rectangle2D.getX() + rectangle2D.getWidth() * 0.18, rectangle2D.getY() + rectangle2D.getHeight() * 0.3, 1000.0, StatesOfMatterGlobalState.temperatureUnitsProperty);
        this.m_thermometerNode.setOffset(rectangle2D.getX() + rectangle2D.getWidth() * 0.23, rectangle2D.getY() - rectangle2D.getHeight() * 1.2);
        this.addWorldChild(this.m_thermometerNode);
        StoveNode stoveNode = new StoveNode(this.m_model);
        stoveNode.setScale(3450.0 / stoveNode.getFullBoundsReference().height);
        stoveNode.setOffset(this.m_particleContainer.getFullBoundsReference().getCenterX() - stoveNode.getFullBoundsReference().width / 2.0, this.m_particleContainer.getFullBoundsReference().getMaxY() + 600.0);
        this.addWorldChild(stoveNode);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(new Resettable[]{multipleParticleModel, this}, this, 18, Color.BLACK, new Color(255, 153, 0)){
            {
                this.setConfirmationEnabled(false);
                this.scale(30.0);
            }
        };
        this.addWorldChild(resetAllButtonNode);
        this.m_clockRunning.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                multipleParticleModel.getClock().setRunning(bl);
            }
        });
        FloatingClockControlNode floatingClockControlNode = new FloatingClockControlNode(this.m_clockRunning, null, multipleParticleModel.getClock(), null, new Property<Color>(Color.white)){
            {
                this.scale(30.0);
            }
        };
        this.addWorldChild(floatingClockControlNode);
        double d = -Math.max(resetAllButtonNode.getFullBoundsReference().width, floatingClockControlNode.getFullBoundsReference().width) / 2.0;
        resetAllButtonNode.setOffset(d - resetAllButtonNode.getFullBoundsReference().width / 2.0, stoveNode.getFullBoundsReference().getMaxY() - resetAllButtonNode.getFullBoundsReference().height);
        floatingClockControlNode.setOffset(resetAllButtonNode.getFullBoundsReference().getCenterX() - floatingClockControlNode.getFullBoundsReference().width / 2.0, resetAllButtonNode.getFullBoundsReference().getMinY() - floatingClockControlNode.getFullBoundsReference().height - 200.0);
    }

    public void reset() {
        this.m_clockRunning.set(true);
        this.m_particleContainer.reset();
    }

    private void updateThermometerTemperature() {
        this.m_thermometerNode.setTemperatureInDegreesKelvin(this.m_model.getTemperatureInKelvin());
    }
}

