/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.module.solidliquidgas;

import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.model.engine.WaterMoleculeStructure;
import edu.colorado.phet.statesofmatter.model.particle.ArgonAtom;
import edu.colorado.phet.statesofmatter.model.particle.ConfigurableStatesOfMatterAtom;
import edu.colorado.phet.statesofmatter.model.particle.HydrogenAtom;
import edu.colorado.phet.statesofmatter.model.particle.NeonAtom;
import edu.colorado.phet.statesofmatter.model.particle.OxygenAtom;
import edu.colorado.phet.statesofmatter.view.ModelViewTransform;
import edu.colorado.phet.statesofmatter.view.ParticleNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class MoleculeImageLabel
extends JLabel {
    private static final ModelViewTransform PARTICLE_MVT = new ModelViewTransform(300.0, 300.0, 0.0, 0.0, false, true);

    public MoleculeImageLabel(final int n, final MultipleParticleModel multipleParticleModel) {
        PNode pNode;
        switch (n) {
            case 2: {
                pNode = new ParticleNode(new ArgonAtom(0.0, 0.0), PARTICLE_MVT, false, true, false);
                break;
            }
            case 1: {
                pNode = new ParticleNode(new NeonAtom(0.0, 0.0), PARTICLE_MVT, false, true, false);
                break;
            }
            case 4: {
                ModelViewTransform modelViewTransform = new ModelViewTransform(300.0, 300.0, 0.0, 0.0, false, true);
                pNode = new PNode();
                pNode.addChild(new ParticleNode(new OxygenAtom(-0.45, 0.0), modelViewTransform, false, true, false));
                pNode.addChild(new ParticleNode(new OxygenAtom(0.45, 0.0), modelViewTransform, false, true, false));
                break;
            }
            case 5: {
                ModelViewTransform modelViewTransform = new ModelViewTransform(500.0, 500.0, 0.0, 0.0, false, true);
                WaterMoleculeStructure waterMoleculeStructure = WaterMoleculeStructure.getInstance();
                pNode = new PNode();
                pNode.addChild(new ParticleNode(new HydrogenAtom(waterMoleculeStructure.getStructureArrayX()[1], waterMoleculeStructure.getStructureArrayY()[1]), modelViewTransform, false, true, false));
                pNode.addChild(new ParticleNode(new OxygenAtom(waterMoleculeStructure.getStructureArrayX()[0], waterMoleculeStructure.getStructureArrayY()[0]), modelViewTransform, false, true, false));
                pNode.addChild(new ParticleNode(new HydrogenAtom(waterMoleculeStructure.getStructureArrayX()[2], waterMoleculeStructure.getStructureArrayY()[2]), modelViewTransform, false, true, false));
                break;
            }
            case 6: {
                pNode = new ParticleNode(new ConfigurableStatesOfMatterAtom(0.0, 0.0), PARTICLE_MVT, false, true, false);
                break;
            }
            default: {
                assert (false);
                pNode = new ParticleNode(new OxygenAtom(0.0, 0.0), PARTICLE_MVT, false, true, false);
            }
        }
        pNode.setScale(0.05);
        this.setIcon(new ImageIcon(pNode.toImage()));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (multipleParticleModel.getMoleculeType() != n) {
                    multipleParticleModel.setMoleculeType(n);
                }
            }
        });
    }
}

