/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine.kinetic;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.engine.kinetic.Thermostat;
import java.util.Random;

public class AndersenThermostat
implements Thermostat {
    final MoleculeForceAndMotionDataSet m_moleculeDataSet;
    final Vector2D[] m_moleculeVelocities;
    final double[] m_moleculeRotationRates;
    final Random m_rand;
    double m_targetTemperature;
    final double m_minModelTemperature;

    public AndersenThermostat(MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet, double d) {
        this.m_moleculeDataSet = moleculeForceAndMotionDataSet;
        this.m_targetTemperature = 0.15;
        this.m_minModelTemperature = d;
        this.m_rand = new Random();
        this.m_moleculeVelocities = moleculeForceAndMotionDataSet.getMoleculeVelocities();
        this.m_moleculeRotationRates = moleculeForceAndMotionDataSet.getMoleculeRotationRates();
    }

    public void adjustTemperature() {
        double d;
        double d2 = d = 0.9999;
        double d3 = this.m_targetTemperature;
        if (d3 <= this.m_minModelTemperature) {
            d = 0.992;
            d2 = 0.999;
            d3 = 0.0;
        }
        double d4 = 1.0 / this.m_moleculeDataSet.getMoleculeMass();
        double d5 = 1.0 / this.m_moleculeDataSet.getMoleculeRotationalInertia();
        double d6 = Math.sqrt(d3 * d4 * (1.0 - Math.pow(d, 2.0)));
        double d7 = Math.sqrt(d3 * d5 * (1.0 - Math.pow(d, 2.0)));
        for (int i = 0; i < this.m_moleculeDataSet.getNumberOfMolecules(); ++i) {
            double d8 = this.m_moleculeVelocities[i].getX() * d + this.m_rand.nextGaussian() * d6;
            double d9 = this.m_moleculeVelocities[i].getY() * d2 + this.m_rand.nextGaussian() * d6;
            this.m_moleculeVelocities[i].setComponents(d8, d9);
            this.m_moleculeRotationRates[i] = d * this.m_moleculeRotationRates[i] + this.m_rand.nextGaussian() * d7;
        }
    }

    public void setTargetTemperature(double d) {
        this.m_targetTemperature = d;
    }
}

