/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.model.engine.AbstractPhaseStateChanger;
import edu.colorado.phet.statesofmatter.model.engine.AtomPositionUpdater;
import edu.colorado.phet.statesofmatter.model.engine.WaterAtomPositionUpdater;
import java.awt.geom.Point2D;
import java.util.Random;

public class WaterPhaseStateChanger
extends AbstractPhaseStateChanger {
    private final AtomPositionUpdater m_positionUpdater = new WaterAtomPositionUpdater();

    public WaterPhaseStateChanger(MultipleParticleModel multipleParticleModel) {
        super(multipleParticleModel);
        assert (this.m_model.getMoleculeDataSetRef().getAtomsPerMolecule() == 3);
    }

    public void setPhase(int n) {
        switch (n) {
            case 1: {
                this.setPhaseSolid();
                break;
            }
            case 2: {
                this.setPhaseLiquid();
                break;
            }
            case 3: {
                this.setPhaseGas();
            }
        }
        MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet = this.m_model.getMoleculeDataSetRef();
        this.m_model.getMoleculeDataSetRef().setNumberOfSafeMolecules(moleculeForceAndMotionDataSet.getNumberOfMolecules());
        this.m_positionUpdater.updateAtomPositions(moleculeForceAndMotionDataSet);
        for (int i = 0; i < 100; ++i) {
            this.m_model.step();
        }
    }

    private void setPhaseSolid() {
        this.m_model.setTemperature(0.15);
        MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet = this.m_model.getMoleculeDataSetRef();
        int n = moleculeForceAndMotionDataSet.getNumberOfMolecules();
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        Vector2D[] vector2DArray = moleculeForceAndMotionDataSet.getMoleculeVelocities();
        double[] dArray = moleculeForceAndMotionDataSet.getMoleculeRotationAngles();
        double[] dArray2 = moleculeForceAndMotionDataSet.getMoleculeRotationRates();
        Random random = new Random();
        double d = Math.sqrt(this.m_model.getTemperatureSetPoint());
        int n2 = (int)Math.sqrt(n);
        for (int i = 0; i < n; ++i) {
            vector2DArray[i].setComponents(d * random.nextGaussian(), d * random.nextGaussian());
            dArray2[i] = random.nextDouble() * d * Math.PI * 2.0;
        }
        double d2 = (double)(n2 - 1) * 1.4;
        double d3 = this.m_model.getNormalizedContainerWidth() / 2.0 - d2 / 2.0;
        double d4 = 1.4;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2 && n3 < n; ++n3, ++j) {
                double d5 = d3 + (double)j * 1.4;
                if (i % 2 != 0) {
                    d5 += 0.7;
                }
                double d6 = d4 + (double)i * 1.4 * 0.866;
                point2DArray[i * n2 + j].setLocation(d5, d6);
                dArray[i * n2 + j] = random.nextDouble() * 2.0 * Math.PI;
            }
        }
    }

    private void setPhaseLiquid() {
        int n;
        this.m_model.setTemperature(0.34);
        MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet = this.m_model.getMoleculeDataSetRef();
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        Vector2D[] vector2DArray = moleculeForceAndMotionDataSet.getMoleculeVelocities();
        double[] dArray = moleculeForceAndMotionDataSet.getMoleculeRotationAngles();
        double[] dArray2 = moleculeForceAndMotionDataSet.getMoleculeRotationRates();
        Random random = new Random();
        double d = Math.sqrt(this.m_model.getTemperatureSetPoint());
        int n2 = moleculeForceAndMotionDataSet.getNumberOfMolecules();
        for (n = 0; n < n2; ++n) {
            vector2DArray[n].setComponents(d * random.nextGaussian(), d * random.nextGaussian());
            dArray2[n] = random.nextDouble() * d * Math.PI * 2.0;
        }
        n = 0;
        Point2D.Double double_ = new Point2D.Double(this.m_model.getNormalizedContainerWidth() / 2.0, this.m_model.getNormalizedContainerHeight() / 4.0);
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        block1: for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 500; ++j) {
                double d2 = (double)n3 * 1.4 * 0.8;
                double d3 = (double)n4 / (double)n5 * 2.0 * Math.PI + (double)n5 / (Math.PI * 4);
                double d4 = ((Point2D)double_).getX() + d2 * Math.cos(d3);
                double d5 = ((Point2D)double_).getY() + d2 * Math.sin(d3);
                if (++n4 >= n5) {
                    n5 = (int)((double)(++n3 * 2) * Math.PI / 1.1199999999999999);
                    n4 = 0;
                }
                if (!(d4 > 2.5) || !(d4 < this.m_model.getNormalizedContainerWidth() - 2.5) || !(d5 > 2.5) || !(d4 < this.m_model.getNormalizedContainerHeight() - 2.5)) continue;
                point2DArray[n].setLocation(d4, d5);
                dArray[n] = d3 + 1.5707963267948966;
                ++n;
                continue block1;
            }
        }
    }

    private void setPhaseGas() {
        this.m_model.setTemperature(1.0);
        MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet = this.m_model.getMoleculeDataSetRef();
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        Vector2D[] vector2DArray = moleculeForceAndMotionDataSet.getMoleculeVelocities();
        double[] dArray = moleculeForceAndMotionDataSet.getMoleculeRotationAngles();
        double[] dArray2 = moleculeForceAndMotionDataSet.getMoleculeRotationRates();
        Random random = new Random();
        double d = Math.sqrt(this.m_model.getTemperatureSetPoint());
        int n = moleculeForceAndMotionDataSet.getNumberOfMolecules();
        for (int i = 0; i < n; ++i) {
            point2DArray[i].setLocation(0.0, 0.0);
            vector2DArray[i].setComponents(d * random.nextGaussian(), d * random.nextGaussian());
            dArray[i] = random.nextDouble() * Math.PI * 2.0;
            dArray2[i] = random.nextDouble() * d * Math.PI * 2.0;
        }
        double d2 = this.m_model.getNormalizedContainerWidth() - 5.0;
        double d3 = this.m_model.getNormalizedContainerHeight() - 5.0;
        block1: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 500; ++j) {
                Point2D point2D;
                double d4 = 2.5 + random.nextDouble() * d2;
                double d5 = 2.5 + random.nextDouble() * d3;
                boolean bl = true;
                for (int k = 0; k < i; ++k) {
                    if (!(point2DArray[k].distance(d4, d5) < 1.4)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    point2DArray[i].setLocation(d4, d5);
                    continue block1;
                }
                if (j != 499 || (point2D = this.findOpenMoleculeLocation()) == null) continue;
                point2DArray[i].setLocation(point2D);
            }
        }
    }
}

