/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.model.engine.AbstractVerletAlgorithm;
import edu.colorado.phet.statesofmatter.model.engine.AtomPositionUpdater;
import edu.colorado.phet.statesofmatter.model.engine.DiatomicAtomPositionUpdater;
import java.awt.geom.Point2D;

public class DiatomicVerletAlgorithm
extends AbstractVerletAlgorithm {
    final AtomPositionUpdater m_positionUpdater = new DiatomicAtomPositionUpdater();

    public DiatomicVerletAlgorithm(MultipleParticleModel multipleParticleModel) {
        super(multipleParticleModel);
    }

    public double getPressure() {
        return this.m_pressure;
    }

    public double getTemperature() {
        return this.m_temperature;
    }

    public void updateForcesAndMotion() {
        double d;
        int n;
        MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet = this.m_model.getMoleculeDataSetRef();
        int n2 = moleculeForceAndMotionDataSet.getNumberOfMolecules();
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        Point2D[] point2DArray2 = moleculeForceAndMotionDataSet.getAtomPositions();
        Vector2D[] vector2DArray = moleculeForceAndMotionDataSet.getMoleculeVelocities();
        Vector2D[] vector2DArray2 = moleculeForceAndMotionDataSet.getMoleculeForces();
        Vector2D[] vector2DArray3 = moleculeForceAndMotionDataSet.getNextMoleculeForces();
        double[] dArray = moleculeForceAndMotionDataSet.getMoleculeRotationAngles();
        double[] dArray2 = moleculeForceAndMotionDataSet.getMoleculeRotationRates();
        double[] dArray3 = moleculeForceAndMotionDataSet.getMoleculeTorques();
        double[] dArray4 = moleculeForceAndMotionDataSet.getNextMoleculeTorques();
        double d2 = 1.0 / moleculeForceAndMotionDataSet.getMoleculeMass();
        double d3 = 1.0 / moleculeForceAndMotionDataSet.getMoleculeRotationalInertia();
        double d4 = this.m_model.getNormalizedContainerHeight();
        double d5 = this.m_model.getNormalizedContainerWidth();
        double d6 = 0.0;
        for (n = 0; n < n2; ++n) {
            d = point2DArray[n].getX() + 0.02 * vector2DArray[n].getX() + 2.0E-4 * vector2DArray2[n].getX() * d2;
            double d7 = point2DArray[n].getY() + 0.02 * vector2DArray[n].getY() + 2.0E-4 * vector2DArray2[n].getY() * d2;
            point2DArray[n].setLocation(d, d7);
            int n3 = n;
            dArray[n3] = dArray[n3] + (0.02 * dArray2[n] + 2.0E-4 * dArray3[n] * d3);
        }
        this.m_positionUpdater.updateAtomPositions(moleculeForceAndMotionDataSet);
        for (n = 0; n < n2; ++n) {
            vector2DArray3[n].setComponents(0.0, 0.0);
            dArray4[n] = 0.0;
            this.calculateWallForce(point2DArray[n], d5, d4, vector2DArray3[n]);
            if (vector2DArray3[n].getY() < 0.0) {
                d6 += -vector2DArray3[n].getY();
            } else if (point2DArray[n].getY() > this.m_model.getNormalizedContainerHeight() / 2.0) {
                d6 += Math.abs(vector2DArray3[n].getX());
            }
            d = this.m_model.getGravitationalAcceleration();
            if (this.m_model.getTemperatureSetPoint() < 0.1) {
                d *= (0.1 - this.m_model.getTemperatureSetPoint()) * 50.0 + 1.0;
            }
            vector2DArray3[n].setY(vector2DArray3[n].getY() - d);
        }
        this.updatePressure(d6);
        if (moleculeForceAndMotionDataSet.getNumberOfSafeMolecules() < n2) {
            this.updateMoleculeSafety();
        }
        Vector2D vector2D = new Vector2D();
        for (int i = 0; i < moleculeForceAndMotionDataSet.getNumberOfSafeMolecules(); ++i) {
            for (int j = i + 1; j < moleculeForceAndMotionDataSet.getNumberOfSafeMolecules(); ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        double d8;
                        double d9 = point2DArray2[2 * i + k].getX() - point2DArray2[2 * j + i2].getX();
                        double d10 = d9 * d9 + (d8 = point2DArray2[2 * i + k].getY() - point2DArray2[2 * j + i2].getY()) * d8;
                        if (!(d10 < 6.25)) continue;
                        if (d10 < 0.7225) {
                            d10 = 0.7225;
                        }
                        double d11 = 1.0 / d10;
                        double d12 = d11 * d11 * d11;
                        double d13 = 48.0 * d11 * d12 * (d12 - 0.5);
                        double d14 = d9 * d13;
                        double d15 = d8 * d13;
                        vector2D.setComponents(d14, d15);
                        vector2DArray3[i].add(vector2D);
                        vector2DArray3[j].subtract(vector2D);
                        int n4 = i;
                        dArray4[n4] = dArray4[n4] + ((point2DArray2[2 * i + k].getX() - point2DArray[i].getX()) * d15 - (point2DArray2[2 * i + k].getY() - point2DArray[i].getY()) * d14);
                        int n5 = j;
                        dArray4[n5] = dArray4[n5] - ((point2DArray2[2 * j + i2].getX() - point2DArray[j].getX()) * d15 - (point2DArray2[2 * j + i2].getY() - point2DArray[j].getY()) * d14);
                        this.m_potentialEnergy += 4.0 * d12 * (d12 - 1.0) + 0.016316891136;
                    }
                }
            }
        }
        double d16 = 0.0;
        double d17 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d18 = vector2DArray[i].getX() + 0.01 * (vector2DArray2[i].getX() + vector2DArray3[i].getX()) * d2;
            double d19 = vector2DArray[i].getY() + 0.01 * (vector2DArray2[i].getY() + vector2DArray3[i].getY()) * d2;
            vector2DArray[i].setComponents(d18, d19);
            int n6 = i;
            dArray2[n6] = dArray2[n6] + 0.01 * (dArray3[i] + dArray4[i]) * d3;
            d16 += 0.5 * moleculeForceAndMotionDataSet.getMoleculeMass() * (Math.pow(vector2DArray[i].getX(), 2.0) + Math.pow(vector2DArray[i].getY(), 2.0));
            d17 += 0.5 * moleculeForceAndMotionDataSet.getMoleculeRotationalInertia() * Math.pow(dArray2[i], 2.0);
            vector2DArray2[i].setComponents(vector2DArray3[i].getX(), vector2DArray3[i].getY());
            dArray3[i] = dArray4[i];
        }
        this.m_temperature = (d16 + d17) / (double)n2 / 1.5;
    }
}

