/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.model.engine.MoleculeForceAndMotionCalculator;
import java.awt.geom.Point2D;

public abstract class AbstractVerletAlgorithm
implements MoleculeForceAndMotionCalculator {
    protected final MultipleParticleModel m_model;
    protected double m_potentialEnergy;
    protected double m_pressure;
    protected double m_temperature;

    public AbstractVerletAlgorithm(MultipleParticleModel multipleParticleModel) {
        this.m_model = multipleParticleModel;
        this.m_potentialEnergy = 0.0;
        this.m_pressure = 0.0;
        this.m_temperature = 0.0;
    }

    protected void calculateWallForce(Point2D point2D, double d, double d2, Vector2D vector2D) {
        double d3;
        assert (vector2D != null);
        assert (point2D != null);
        if (vector2D == null || point2D == null) {
            return;
        }
        double d4 = point2D.getX();
        double d5 = point2D.getY();
        double d6 = 0.8979696386474985;
        if (d5 < this.m_model.getNormalizedContainerWidth()) {
            if (d4 < 1.122462048309373) {
                if (d4 < d6) {
                    d4 = d4 < 0.0 && this.m_model.getContainerExploded() ? Double.POSITIVE_INFINITY : d6;
                }
                vector2D.setX(48.0 / Math.pow(d4, 13.0) - 24.0 / Math.pow(d4, 7.0));
                this.m_potentialEnergy += 4.0 / Math.pow(d4, 12.0) - 4.0 / Math.pow(d4, 6.0) + 1.0;
            } else if (d - d4 < 1.122462048309373) {
                d3 = d - d4;
                if (d3 < d6) {
                    if (d3 < 0.0 && this.m_model.getContainerExploded()) {
                        d4 = Double.POSITIVE_INFINITY;
                    } else {
                        d3 = d6;
                    }
                }
                vector2D.setX(-(48.0 / Math.pow(d3, 13.0)) + 24.0 / Math.pow(d3, 7.0));
                this.m_potentialEnergy += 4.0 / Math.pow(d3, 12.0) - 4.0 / Math.pow(d3, 6.0) + 1.0;
            }
        }
        if (d5 < 1.122462048309373) {
            if (d5 < d6) {
                if (d5 < 0.0 && !this.m_model.getContainerExploded()) {
                    this.m_model.explodeContainer();
                }
                d5 = d6;
            }
            if (!this.m_model.getContainerExploded() || d4 > 0.0 && d4 < d) {
                vector2D.setY(48.0 / Math.pow(d5, 13.0) - 24.0 / Math.pow(d5, 7.0));
                this.m_potentialEnergy += 4.0 / Math.pow(d5, 12.0) - 4.0 / Math.pow(d5, 6.0) + 1.0;
            }
        } else if (d2 - d5 < 1.122462048309373 && !this.m_model.getContainerExploded()) {
            d3 = d2 - d5;
            if (d3 < d6) {
                d3 = d6;
            }
            vector2D.setY(-48.0 / Math.pow(d3, 13.0) + 24.0 / Math.pow(d3, 7.0));
            this.m_potentialEnergy += 4.0 / Math.pow(d3, 12.0) - 4.0 / Math.pow(d3, 6.0) + 1.0;
        }
    }

    protected void updateMoleculeSafety() {
        MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet = this.m_model.getMoleculeDataSetRef();
        int n = moleculeForceAndMotionDataSet.getNumberOfSafeMolecules();
        int n2 = moleculeForceAndMotionDataSet.getNumberOfMolecules();
        if (n2 == n) {
            return;
        }
        int n3 = moleculeForceAndMotionDataSet.getAtomsPerMolecule();
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        Point2D[] point2DArray2 = moleculeForceAndMotionDataSet.getAtomPositions();
        Vector2D[] vector2DArray = moleculeForceAndMotionDataSet.getMoleculeVelocities();
        Vector2D[] vector2DArray2 = moleculeForceAndMotionDataSet.getMoleculeForces();
        double[] dArray = moleculeForceAndMotionDataSet.getMoleculeRotationRates();
        double[] dArray2 = moleculeForceAndMotionDataSet.getMoleculeRotationAngles();
        for (int i = n; i < n2; ++i) {
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (!(point2DArray[i].distance(point2DArray[j]) < 2.0)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (i != n) {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    Point2D point2D = point2DArray2[n * n3 + n4];
                    point2DArray2[n * n3 + n4] = point2DArray2[n3 * i + n4];
                    point2DArray2[n3 * i + n4] = point2D;
                }
                n4 = n;
                Point2D point2D = point2DArray[n4];
                point2DArray[n4] = point2DArray[i];
                point2DArray[i] = point2D;
                Vector2D vector2D = vector2DArray[n4];
                vector2DArray[n4] = vector2DArray[i];
                vector2DArray[i] = vector2D;
                Vector2D vector2D2 = vector2DArray2[n4];
                vector2DArray2[n4] = vector2DArray2[i];
                vector2DArray2[i] = vector2D2;
                double d = dArray2[n4];
                dArray2[n4] = dArray2[i];
                dArray2[i] = d;
                double d2 = dArray[n4];
                dArray[n4] = dArray[i];
                dArray[i] = d2;
            }
            moleculeForceAndMotionDataSet.setNumberOfSafeMolecules(++n);
        }
    }

    protected void updatePressure(double d) {
        if (this.m_model.getContainerExploded()) {
            this.m_pressure = 0.0;
        } else {
            this.m_pressure = 0.0010000000000000009 * (d / (this.m_model.getNormalizedContainerWidth() + this.m_model.getNormalizedContainerHeight())) + 0.999 * this.m_pressure;
            if (this.m_pressure > 1.05 && !this.m_model.getContainerExploded()) {
                this.m_model.explodeContainer();
            }
        }
    }

    public void setScaledEpsilon(double d) {
        System.err.println("Warning: Setting epsilon is not implemented for this class, request ignored.");
    }

    public double getScaledEpsilon() {
        System.err.println("Warning: Getting scaled epsilon is not implemented for this class, returning zero.");
        return 0.0;
    }
}

