/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.model.engine;

import edu.colorado.phet.statesofmatter.model.MoleculeForceAndMotionDataSet;
import edu.colorado.phet.statesofmatter.model.MultipleParticleModel;
import edu.colorado.phet.statesofmatter.model.engine.PhaseStateChanger;
import java.awt.geom.Point2D;

public abstract class AbstractPhaseStateChanger
implements PhaseStateChanger {
    protected final MultipleParticleModel m_model;

    public AbstractPhaseStateChanger(MultipleParticleModel multipleParticleModel) {
        this.m_model = multipleParticleModel;
    }

    public void setPhase(int n) {
    }

    protected Point2D findOpenMoleculeLocation() {
        MoleculeForceAndMotionDataSet moleculeForceAndMotionDataSet = this.m_model.getMoleculeDataSetRef();
        Point2D[] point2DArray = moleculeForceAndMotionDataSet.getMoleculeCenterOfMassPositions();
        double d = moleculeForceAndMotionDataSet.getAtomsPerMolecule() == 1 ? 1.2 : 1.5;
        double d2 = this.m_model.getNormalizedContainerWidth() - 5.0;
        double d3 = this.m_model.getNormalizedContainerHeight() - 5.0;
        int n = 0;
        while ((double)n < d2 / d) {
            int n2 = 0;
            while ((double)n2 < d3 / d) {
                double d4 = 2.5 + (double)n * d;
                double d5 = 2.5 + (double)n2 * d;
                boolean bl = true;
                for (int i = 0; i < moleculeForceAndMotionDataSet.getNumberOfMolecules(); ++i) {
                    if (!(point2DArray[i].distance(d4, d5) < d)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return new Point2D.Double(d4, d5);
                }
                ++n2;
            }
            ++n;
        }
        System.err.println("Error: No open positions available for molecule.");
        return null;
    }
}

