/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.developer;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.statesofmatter.developer.StatesOfMaterDeveloperControlsDialog;
import edu.colorado.phet.statesofmatter.view.AbstractStatesOfMatterApplication;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;

public class DeveloperControlsMenuItem
extends JCheckBoxMenuItem {
    private final PhetApplication _app;
    private JDialog _developerControlsDialog;

    public DeveloperControlsMenuItem(PhetApplication phetApplication) {
        super("Developer controls...");
        this._app = phetApplication;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeveloperControlsMenuItem.this.handleDeveloperControls();
            }
        });
    }

    private void handleDeveloperControls() {
        if (this.isSelected()) {
            PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
            if (this._app instanceof AbstractStatesOfMatterApplication) {
                this._developerControlsDialog = new StatesOfMaterDeveloperControlsDialog((Frame)phetFrame, this._app);
            }
            this._developerControlsDialog.setVisible(true);
            this._developerControlsDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    this.cleanup();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.cleanup();
                }

                private void cleanup() {
                    DeveloperControlsMenuItem.this.setSelected(false);
                    DeveloperControlsMenuItem.this._developerControlsDialog = null;
                }
            });
        } else {
            this._developerControlsDialog.dispose();
        }
    }
}

