/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.DoubleArrowNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.Timer;

public class ResizeArrowNode
extends PhetPNode {
    private final DoubleArrowNode m_adjusterArrow;
    private final Color m_normalFillColor;
    private final Color m_highlightedFillColor;
    private final FlashController flashController;

    public ResizeArrowNode(double d, double d2, Color color, Color color2) {
        this.m_normalFillColor = color;
        this.m_highlightedFillColor = color2;
        this.m_adjusterArrow = new DoubleArrowNode(new Point2D.Double(-d / 2.0, 0.0), new Point2D.Double(d / 2.0, 0.0), d * 0.3, d * 0.7, d * 0.25);
        this.m_adjusterArrow.rotate(d2);
        this.m_adjusterArrow.setPaint(this.m_normalFillColor);
        this.m_adjusterArrow.setPickable(true);
        this.addChild(this.m_adjusterArrow);
        this.m_adjusterArrow.addInputEventListener(new CursorHandler());
        this.m_adjusterArrow.addInputEventListener(new PBasicInputEventHandler(){
            private boolean m_mouseIsPressed;
            private boolean m_mouseIsInside;

            public void mousePressed(PInputEvent pInputEvent) {
                this.m_mouseIsPressed = true;
                ResizeArrowNode.this.m_adjusterArrow.setPaint(ResizeArrowNode.this.m_highlightedFillColor);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                this.m_mouseIsPressed = false;
                if (!this.m_mouseIsInside) {
                    ResizeArrowNode.this.m_adjusterArrow.setPaint(ResizeArrowNode.this.m_normalFillColor);
                }
            }

            public void mouseEntered(PInputEvent pInputEvent) {
                this.m_mouseIsInside = true;
                ResizeArrowNode.this.m_adjusterArrow.setPaint(ResizeArrowNode.this.m_highlightedFillColor);
                if (ResizeArrowNode.this.flashController.isFlashing()) {
                    ResizeArrowNode.this.flashController.stop();
                }
            }

            public void mouseExited(PInputEvent pInputEvent) {
                this.m_mouseIsInside = false;
                if (!this.m_mouseIsPressed) {
                    ResizeArrowNode.this.m_adjusterArrow.setPaint(ResizeArrowNode.this.m_normalFillColor);
                }
            }
        });
        this.flashController = new FlashController(this.m_adjusterArrow, this.m_normalFillColor, this.m_highlightedFillColor);
    }

    private static class FlashController {
        private boolean flashOn = false;
        private int flashCount = 0;
        private Timer flashTimer;

        private FlashController(final PPath pPath, final Color color, final Color color2) {
            this.flashTimer = new Timer(300, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (FlashController.this.flashOn) {
                        FlashController.this.flashOn = false;
                        pPath.setPaint(color);
                        FlashController.this.flashCount++;
                        if (FlashController.this.flashCount < 2) {
                            FlashController.this.flashTimer.setDelay(500);
                            FlashController.this.flashTimer.restart();
                        } else {
                            FlashController.this.flashTimer.stop();
                        }
                    } else {
                        FlashController.this.flashOn = true;
                        pPath.setPaint(color2);
                        FlashController.this.flashTimer.setDelay(500);
                        FlashController.this.flashTimer.restart();
                    }
                }
            });
        }

        public boolean isFlashing() {
            return this.flashTimer.isRunning();
        }

        public void stop() {
            this.flashTimer.stop();
        }
    }
}

