/*
 * Decompiled with CFR 0.152.
 */
package jass.render;

import jass.engine.BufferNotAvailableException;
import jass.engine.In;
import jass.engine.Source;
import jass.generators.AudioIn;
import jass.render.RTPlay;

public class SourcePlayer
extends In {
    private int bufferSize;
    private int bufferSizeJavaSound;
    private float srate;
    private float maxSignal = 0.0f;
    private boolean agc = true;
    private long t = 0L;
    private double real_time = 0.0;
    private float[] tempBuf;
    private boolean stopFlag = false;
    private String preferredMixer = null;
    private boolean muted = false;
    private boolean useNativeSound = false;
    private boolean useASIO = false;
    private int numRtAudioBuffers = 0;
    private float counter = 0.0f;
    private boolean ASIOconnected = false;
    private String audioAPI = "";
    private int outputchannelNum = 2;
    private int inputchannelNum = 0;
    private AudioIn myInput = null;
    private RTPlay pb;
    private int nchannels = 1;

    public native int initAsioJass(int var1, int var2, int var3, int var4, AudioIn var5);

    public native void cleanupASIO();

    public void setMute(boolean bl) {
        this.muted = bl;
    }

    public SourcePlayer(int n, int n2, float f) {
        this.bufferSize = n;
        this.bufferSizeJavaSound = n2;
        this.srate = f;
        this.tempBuf = new float[n];
    }

    private float[] getNextBuffer() throws BufferNotAvailableException {
        int n;
        int n2 = this.sourceContainer.size();
        for (n = 0; n < this.bufferSize; ++n) {
            this.tempBuf[n] = 0.0f;
        }
        for (n = 0; n < n2; ++n) {
            float[] fArray = ((Source)this.sourceContainer.elementAt(n)).getBuffer(this.t);
            if (this.muted) continue;
            for (int i = 0; i < this.bufferSize; ++i) {
                int n3 = i;
                this.tempBuf[n3] = this.tempBuf[n3] + fArray[i];
            }
        }
        if (this.agc) {
            for (n = 0; n < this.bufferSize; ++n) {
                float f = Math.abs(this.tempBuf[n]);
                if (!(f > this.maxSignal)) continue;
                this.maxSignal = f;
            }
            if (this.maxSignal != 0.0f) {
                n = 0;
                while (n < this.bufferSize) {
                    int n4 = n++;
                    this.tempBuf[n4] = this.tempBuf[n4] / this.maxSignal;
                }
            }
        }
        ++this.t;
        return this.tempBuf;
    }

    public void run() {
        int n = this.sourceContainer.size();
        if (n == 0) {
            System.out.println("no sources to play, nsources=" + n);
            return;
        }
        if (this.useNativeSound && this.audioAPI.equals("ASIO")) {
            this.initASIO();
        } else {
            if (this.useNativeSound) {
                this.pb = new RTPlay(this.srate, this.nchannels, this.bufferSize, this.numRtAudioBuffers);
                try {
                    SourcePlayer.sleep(100L);
                }
                catch (Exception exception) {}
            } else {
                this.pb = new RTPlay(this.bufferSizeJavaSound, this.srate, 16, this.nchannels, true, this.preferredMixer);
            }
            this.t = 0L;
            for (int i = 0; i < n; ++i) {
                ((Source)this.sourceContainer.elementAt(i)).setTime(this.t);
            }
            while (!this.stopFlag) {
                try {
                    this.pb.write(this.getNextBuffer());
                }
                catch (BufferNotAvailableException bufferNotAvailableException) {
                    System.out.println(bufferNotAvailableException + " Sourceplayer could not get play buffer");
                    System.exit(0);
                }
            }
            System.out.println("The shutdown hook in RTPlay is executing");
            this.pb.close();
        }
    }

    public void initASIO() {
        try {
            System.loadLibrary("JassAsio");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("Could not load shared library JassAsio");
        }
        try {
            SourcePlayer.sleep(500L);
        }
        catch (Exception exception) {
            System.out.print("The sleep function is broken");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("The shutdown hook is executing");
                if (SourcePlayer.this.audioAPI.equals("ASIO")) {
                    SourcePlayer.this.cleanupASIO();
                }
                try {
                    1.sleep(1500L);
                }
                catch (Exception exception) {
                    System.out.print("The sleep function is broken");
                }
            }
        });
        if (this.initAsioJass((int)this.srate, this.bufferSize, this.outputchannelNum, this.inputchannelNum, this.myInput) == 0) {
            this.ASIOconnected = true;
            System.out.println("ASIO has returned and finished.");
        } else {
            this.ASIOconnected = false;
            System.out.println("The ASIO system Could not be initialized.");
        }
        if (this.myInput != null) {
            this.myInput.close();
        }
    }
}

