/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.model.Wavefront;
import edu.colorado.phet.sound.view.RgbReporter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class WaveMediumGraphic
extends PhetImageGraphic
implements SimpleObserver {
    private static Color[] s_lineColor = new Color[256];
    private static Stroke s_defaultStroke;
    private Point2D.Double origin = new Point2D.Double(SoundConfig.s_wavefrontBaseX, SoundConfig.s_wavefrontBaseY);
    private double height = SoundConfig.s_wavefrontHeight;
    private double stroke = 1.0;
    private double radius = SoundConfig.s_wavefrontRadius;
    private boolean isPlanar;
    private double[] amplitudes = new double[Wavefront.s_length];
    private BufferedImage buffImg;
    private Graphics2D g2DBuffImg;
    private AffineTransform nopAT = new AffineTransform();
    private float opacity = 1.0f;
    private double rotationAngle = 0.0;
    private AffineTransform lineRotationXform;
    private WaveMedium waveMedium;
    private RgbReporter rgbReporter;
    private int grayScaleZero = s_lineColor.length / 2;
    public static boolean drawTest;

    private static BufferedImage createBufferedImage() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleImage(800, 800);
    }

    public WaveMediumGraphic(WaveMedium waveMedium, Component component, RgbReporter rgbReporter) {
        super(component, WaveMediumGraphic.createBufferedImage());
        this.waveMedium = waveMedium;
        this.rgbReporter = rgbReporter;
        waveMedium.addObserver(this);
        this.buffImg = super.getImage();
        this.g2DBuffImg = this.buffImg.createGraphics();
        this.g2DBuffImg.setColor(SoundConfig.MIDDLE_GRAY);
        this.g2DBuffImg.setColor(new Color(0, 0, 0, 0));
        this.g2DBuffImg.fill(new Rectangle(this.buffImg.getMinX(), this.buffImg.getMinY(), this.buffImg.getWidth(), this.buffImg.getHeight()));
        this.setGraphicsHints(this.g2DBuffImg);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.origin.getX(), (float)this.origin.getY());
        double d = (double)waveMedium.getMaxX() + this.origin.getX();
        double d2 = Math.asin(this.height / (2.0 * this.radius));
        double d3 = (double)waveMedium.getMaxX() * Math.tan(d2);
        generalPath.lineTo((float)d, (float)(this.origin.getY() - d3));
        generalPath.lineTo((float)d, (float)(this.origin.getY() + d3));
        generalPath.closePath();
    }

    Color getColorForAmplitude(double d, int n, int n2) {
        int n3 = this.rgbReporter.rgbAt(n, n2);
        double d2 = d / 1.0 * (double)n3;
        int n4 = Math.min((int)(d2 + (double)n3), s_lineColor.length - 1);
        return s_lineColor[n4];
    }

    private void setGraphicsHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public void initLayout(Point2D.Double double_, double d, double d2) {
        this.initLayout(double_, d, d2, 0.0);
    }

    public void initLayout(Point2D.Double double_, double d, double d2, double d3) {
        this.origin = double_;
        this.height = d;
        this.radius = d2;
        this.setRotationAngle(d3);
    }

    private void setRotationAngle(double d) {
        this.rotationAngle = d;
        this.lineRotationXform = AffineTransform.getRotateInstance(-Math.toRadians(this.rotationAngle), this.origin.getX(), this.origin.getY());
    }

    public void paint(Graphics2D graphics2D) {
        this.setGraphicsHints(graphics2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        graphics2D.setStroke(s_defaultStroke);
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        Line2D.Float float_3 = new Line2D.Float();
        float f = (float)(Math.asin(this.height / (2.0 * this.radius)) * 57.29577951308232);
        Arc2D.Float float_4 = new Arc2D.Float();
        double d = this.height - 20.0;
        double d2 = this.radius - 20.0;
        this.lineRotationXform = AffineTransform.getRotateInstance(-Math.toRadians(this.rotationAngle), this.origin.getX(), this.origin.getY());
        if (drawTest) {
            int n = 2;
            int n2 = 2;
            Graphics2D graphics2D2 = (Graphics2D)this.buffImg.getGraphics();
            for (int i = (int)d2; i < this.waveMedium.getMaxX(); i += n) {
                double d3 = (double)i * Math.tan(Math.toRadians((double)(-f) + this.rotationAngle));
                double d4 = (double)i * Math.tan(Math.toRadians((double)f + this.rotationAngle));
                for (int j = (int)d3; j < (int)d4; j += n2) {
                    double d5 = i * i + j * j;
                    int n3 = (int)Math.sqrt(d5);
                    if (n3 >= this.waveMedium.getMaxX()) continue;
                    double d6 = this.amplitudes[n3] / 1.0 * (double)this.grayScaleZero;
                    int n4 = (int)(d6 + (double)(s_lineColor.length / 2));
                    graphics2D2.setColor(s_lineColor[n4]);
                    graphics2D2.fillRect((int)this.origin.getX() + i, (int)this.origin.getY() + j, n, n2);
                }
            }
            graphics2D.drawImage(this.buffImg, this.nopAT, null);
        } else {
            for (int i = 0; i < this.waveMedium.getMaxX(); ++i) {
                graphics2D.setColor(this.getColorForAmplitude(this.amplitudes[i], (int)((double)i * this.stroke), 0));
                if (this.isPlanar) {
                    ((Point2D)float_).setLocation(this.origin.getX() + d2 + (double)i * this.stroke, this.origin.getY() - this.height / 2.0);
                    ((Point2D)float_2).setLocation(this.origin.getX() + d2 + (double)i * this.stroke, this.origin.getY() + this.height / 2.0);
                    float_3.setLine(float_, float_2);
                    Shape shape = this.lineRotationXform.createTransformedShape(float_3);
                    graphics2D.draw(shape);
                    continue;
                }
                float_4.setArc(this.origin.getX() - d2 - (double)i * this.stroke, this.origin.getY() - d2 - (double)i * this.stroke, d2 * 2.0 + (double)i * this.stroke * 2.0, d2 * 2.0 + (double)i * this.stroke * 2.0, (double)(-f) + this.rotationAngle, f * 2.0f, 0);
                graphics2D.draw(float_4);
            }
        }
        graphics2D.setComposite(composite);
    }

    public void update() {
        for (int i = 0; i < this.amplitudes.length; ++i) {
            this.amplitudes[i] = this.waveMedium.getAmplitudeAt(i);
        }
        this.repaint();
    }

    static {
        for (int i = 0; i < s_lineColor.length; ++i) {
            WaveMediumGraphic.s_lineColor[i] = new Color(i, i, i);
        }
        s_defaultStroke = new BasicStroke(1.0f);
    }
}

