/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.sound.SoundConfig;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ReflectingWallGraphic
extends PhetShapeGraphic {
    private double x;
    private double y;
    private double w;
    private double h;
    private double theta;
    private Shape xformedWall;
    private AffineTransform xform;
    private Color wallColor = new Color(48, 0, 128);
    private Line2D.Double wallEdge = new Line2D.Double();
    private Stroke wallEdgeStroke = new BasicStroke(4.0f);
    private GeneralPath interferingWaveMask;
    private Rectangle2D.Double wall;
    private boolean displayHelpOrnaments;

    public ReflectingWallGraphic(Component component, Color color, double d, double d2, double d3, double d4, double d5) {
        super(component, null, color);
        this.x = d;
        this.y = d2;
        this.w = d3;
        this.h = d4;
        this.theta = d5;
        this.wall = new Rectangle2D.Double(d, d2, d3, d4);
        this.interferingWaveMask = new GeneralPath();
        this.setAngle(d5);
        this.setLocation(d);
    }

    public Point2D.Double getMidPoint() {
        double d = this.getShape().getBounds2D().getMinX() + this.getShape().getBounds2D().getWidth() / 2.0;
        double d2 = this.getShape().getBounds2D().getMinY() + this.getShape().getBounds2D().getHeight() / 2.0;
        return new Point2D.Double(d, d2);
    }

    public void setLocation(double d) {
        this.xform = AffineTransform.getTranslateInstance(d - this.x, 0.0);
        this.xformedWall = this.xform.createTransformedShape(this.xformedWall);
        this.x = d;
        this.setShape(this.xformedWall);
        this.setInterferingWaveMask();
    }

    public void setAngle(double d) {
        this.theta = d;
        this.xform = AffineTransform.getRotateInstance(-Math.toRadians(d), this.x, this.y);
        this.xformedWall = this.xform.createTransformedShape(this.wall);
        this.setShape(this.xformedWall);
        this.setInterferingWaveMask();
    }

    public double getAngle() {
        return this.theta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterferingWaveMask() {
        double d = 1000.0;
        double d2 = 800.0;
        double d3 = Math.tan(Math.toRadians(this.theta));
        double d4 = Double.isInfinite(d3) ? this.x : this.x - (d2 - this.y) / d3;
        double d5 = Double.isInfinite(d3) ? this.x : this.x - (0.0 - this.y) / d3;
        double d6 = Double.isInfinite(d3) ? d3 : this.y - (d - this.x) * d3;
        GeneralPath generalPath = this.interferingWaveMask;
        synchronized (generalPath) {
            this.interferingWaveMask.reset();
            if (d6 >= 0.0) {
                this.interferingWaveMask.moveTo((float)d4 + 2.0f, (float)d2);
                this.interferingWaveMask.lineTo((float)d + 2.0f, (float)d6);
                this.interferingWaveMask.lineTo((float)d + 2.0f, (float)d2);
                this.interferingWaveMask.closePath();
                this.wallEdge.setLine(d4, d2, d, d6);
            } else {
                this.interferingWaveMask.moveTo((float)d4 + 2.0f, (float)d2);
                this.interferingWaveMask.lineTo((float)d5 + 2.0f, 0.0f);
                this.interferingWaveMask.lineTo((float)d + 2.0f, 0.0f);
                this.interferingWaveMask.lineTo((float)d + 2.0f, (float)d2);
                this.interferingWaveMask.closePath();
                this.wallEdge.setLine(d4, d2, d5, 0.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D) {
        this.pushRenderingHints(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(SoundConfig.MIDDLE_GRAY);
        Shape shape = this.interferingWaveMask;
        synchronized (shape) {
            graphics2D.fill(this.interferingWaveMask);
            graphics2D.setColor(this.wallColor);
            graphics2D.setStroke(this.wallEdgeStroke);
            graphics2D.draw(this.wallEdge);
        }
        if (this.displayHelpOrnaments) {
            shape = new Ellipse2D.Double(this.getMidPoint().getX() - this.h, this.getMidPoint().getY() - this.h, 6.0, 6.0);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.black);
            graphics2D.draw(shape);
            graphics2D.setColor(Color.yellow);
            graphics2D.fill(shape);
            double d = 100.0;
            Arc2D.Double double_ = new Arc2D.Double(this.getMidPoint().getX() - d - this.h, this.getMidPoint().getY() - d - this.h, d * 2.0, d * 2.0, this.getAngle() - 30.0, 60.0, 0);
            Arc2D.Double double_2 = new Arc2D.Double(this.getMidPoint().getX() - d - this.h, this.getMidPoint().getY() - d - this.h, d * 2.0, d * 2.0, this.getAngle() + 150.0, 60.0, 0);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.draw(double_2);
        }
        this.popRenderingHints(graphics2D);
    }
}

