/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.sound.coreadditions.ScalarObservable;
import edu.colorado.phet.sound.coreadditions.ScalarObserver;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class DialGauge
extends CompositePhetGraphic
implements ScalarObserver {
    private ScalarObservable dataSource;
    private String title;
    private String units;
    private Component component;
    private double x;
    private double y;
    private double diam;
    private double min;
    private double max;
    private NeedleGraphic needleGraphic;

    public DialGauge(ScalarObservable scalarObservable, Component component, double d, double d2, double d3, double d4, double d5, String string, String string2) {
        this.dataSource = scalarObservable;
        this.title = string;
        this.units = string2;
        scalarObservable.addObserver(this);
        this.component = component;
        this.x = d;
        this.y = d2;
        this.diam = d3;
        this.min = d4;
        this.max = d5;
        this.addGraphic(new FaceGraphic());
        this.needleGraphic = new NeedleGraphic();
        this.addGraphic(this.needleGraphic);
        this.update();
    }

    public void update() {
        double d = this.dataSource.getValue();
        d = Math.max(Math.min(d, this.max), this.min);
        double d2 = (this.max - d) / (this.max - this.min);
        double d3 = -(3.9269908169872414 + 4.71238898038469 * d2) - 1.5707963267948966;
        this.needleGraphic.update(d3);
    }

    private class FaceGraphic
    extends PhetShapeGraphic {
        private Rectangle2D.Double tickMark;
        private Font font;

        FaceGraphic() {
            super(DialGauge.this.component, null, Color.white, new BasicStroke(5.0f), new Color(80, 80, 40));
            this.font = new PhetFont(1, 8);
            Ellipse2D.Double double_ = new Ellipse2D.Double(DialGauge.this.x - DialGauge.this.diam / 2.0, DialGauge.this.y - DialGauge.this.diam / 2.0, DialGauge.this.diam, DialGauge.this.diam);
            super.setShape(double_);
            this.tickMark = new Rectangle2D.Double(DialGauge.this.x + DialGauge.this.diam / 6.0, DialGauge.this.y - 1.0, DialGauge.this.diam / 8.0, 2.0);
        }

        public void paint(Graphics2D graphics2D) {
            Object object;
            this.pushRenderingHints(graphics2D);
            GraphicsUtil.setAntiAliasingOn(graphics2D);
            super.paint(graphics2D);
            int n = 7;
            graphics2D.setColor(Color.black);
            double d = 2.356194490192345;
            double d2 = 0.7853981633974483;
            for (int i = 0; i < n; ++i) {
                object = graphics2D.getTransform();
                double d3 = d + (double)i * Math.PI / 4.0;
                graphics2D.transform(AffineTransform.getRotateInstance(d3, DialGauge.this.x, DialGauge.this.y));
                graphics2D.fill(this.tickMark);
                graphics2D.setTransform((AffineTransform)object);
            }
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            object = Double.toString(DialGauge.this.min);
            Rectangle2D rectangle2D = this.font.getStringBounds((String)object, fontRenderContext);
            graphics2D.setFont(this.font);
            graphics2D.drawString((String)object, (float)(DialGauge.this.x + Math.cos(d) * (DialGauge.this.diam / 2.0) * 0.7) - (float)rectangle2D.getWidth() / 2.0f, (float)(DialGauge.this.y + Math.sin(d) * (DialGauge.this.diam / 2.0) * 0.7) + (float)rectangle2D.getHeight());
            String string = Double.toString(DialGauge.this.max);
            rectangle2D = this.font.getStringBounds(string, fontRenderContext);
            graphics2D.drawString(Double.toString(DialGauge.this.max), (float)(DialGauge.this.x + Math.cos(d2) * (DialGauge.this.diam / 2.0) * 0.7) - (float)rectangle2D.getWidth() / 2.0f, (float)(DialGauge.this.y + Math.sin(d2) * (DialGauge.this.diam / 2.0) * 0.7) + (float)rectangle2D.getHeight());
            rectangle2D = this.font.getStringBounds(DialGauge.this.units, fontRenderContext);
            graphics2D.drawString(DialGauge.this.units, (float)DialGauge.this.x - (float)rectangle2D.getWidth() / 2.0f, (float)(DialGauge.this.y + DialGauge.this.diam / 2.0 * 0.75));
            rectangle2D = this.font.getStringBounds(DialGauge.this.title, fontRenderContext);
            graphics2D.drawString(DialGauge.this.title, (float)DialGauge.this.x - (float)rectangle2D.getWidth() / 2.0f, (float)(DialGauge.this.y - DialGauge.this.diam / 2.0 * 0.75));
            this.popRenderingHints(graphics2D);
        }
    }

    private class NeedleGraphic
    extends PhetShapeGraphic {
        private Rectangle2D.Double needle;
        private double r;
        private double l;
        private AffineTransform needleTx;
        private Ellipse2D.Double pivot;

        NeedleGraphic() {
            super(DialGauge.this.component, null, Color.red);
            this.r = 0.3;
            this.pivot = new Ellipse2D.Double();
            this.needle = new Rectangle2D.Double();
            this.l = DialGauge.this.diam * 0.5;
            this.needle.setRect(DialGauge.this.x - this.l * this.r, DialGauge.this.y - 1.0, this.l, 2.0);
            super.setShape(this.needle);
        }

        public void paint(Graphics2D graphics2D) {
            this.pushRenderingHints(graphics2D);
            AffineTransform affineTransform = graphics2D.getTransform();
            GraphicsUtil.setAntiAliasingOn(graphics2D);
            graphics2D.transform(this.needleTx);
            super.paint(graphics2D);
            graphics2D.setColor(Color.black);
            graphics2D.fill(this.pivot);
            graphics2D.setTransform(affineTransform);
            this.popRenderingHints(graphics2D);
        }

        void update(double d) {
            this.needleTx = AffineTransform.getRotateInstance(d, DialGauge.this.x, DialGauge.this.y);
            this.pivot.setFrameFromCenter(DialGauge.this.x, DialGauge.this.y, DialGauge.this.x + 2.0, DialGauge.this.y + 2.0);
        }
    }
}

