/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.sound.SoundResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ClockPanelLarge
extends JPanel {
    private JTextField readoutTextField = new JTextField();
    private NumberFormat clockFormat = new DecimalFormat("0.0000");
    private String[] startStopStr = new String[]{PhetCommonResources.getString("Common.StopwatchPanel.start"), PhetCommonResources.getString("Common.StopwatchPanel.stop")};
    private EventChannel eventRegistry = new EventChannel(ClockPanelListener.class);
    private JButton resetBtn;
    private ModelElement modelTickCounter;
    private BaseModel model;
    private double runningTime = 0.0;
    private int state = 0;
    private JButton startStopBtn;

    public ClockPanelLarge(BaseModel baseModel) {
        this.model = baseModel;
        this.setBackground(new Color(237, 225, 113));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.readoutTextField = new JTextField(5);
        Font font = this.readoutTextField.getFont();
        this.readoutTextField.setFont(new Font(font.getName(), 1, 16));
        this.readoutTextField.setEditable(false);
        this.readoutTextField.setHorizontalAlignment(4);
        this.readoutTextField.setText(this.clockFormat.format(0L));
        this.runningTime = 0.0;
        this.modelTickCounter = new ModelElement(){

            public void stepInTime(double d) {
                ClockPanelLarge.this.runningTime = d + ClockPanelLarge.this.runningTime;
                ClockPanelLarge.this.readoutTextField.setText(ClockPanelLarge.this.clockFormat.format(ClockPanelLarge.this.runningTime * 4.0338846308995566E-5));
            }
        };
        this.startStopBtn = new JButton(this.startStopStr[0]);
        this.startStopBtn.addActionListener(new StartStopActionListener());
        this.resetBtn = new JButton(PhetCommonResources.getString("Common.StopwatchPanel.reset"));
        this.resetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClockPanelLarge.this.resetClock();
            }
        });
        this.setLayout(new GridBagLayout());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints = null;
        gridBagConstraints = new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 10, 0, insets, n2, n3);
        this.add((Component)new JLabel(SoundResources.getString("ClockPanelLarge.SimulationTime")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 0, insets, n2, n3);
        this.add((Component)this.readoutTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 17, 0, insets, n2, n3);
        this.add((Component)new JLabel(SoundResources.getString("ClockPanelLarge.Seconds")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 0, insets, n2, n3);
        ++n;
        gridBagConstraints.gridy = n++;
        this.add((Component)this.startStopBtn, gridBagConstraints);
        gridBagConstraints.gridy = n;
        this.add((Component)this.resetBtn, gridBagConstraints);
    }

    private void resetClock() {
        this.model.removeModelElement(this.modelTickCounter);
        this.runningTime = 0.0;
        this.modelTickCounter.stepInTime(0.0);
        ClockPanelEvent clockPanelEvent = new ClockPanelEvent(this);
        clockPanelEvent.setReset(true);
        clockPanelEvent.setRunning(false);
    }

    public void addListener(ClockPanelListener clockPanelListener) {
        this.eventRegistry.addListener(clockPanelListener);
    }

    public class ClockPanelEvent
    extends EventObject {
        boolean isRunning;
        boolean isReset;

        public ClockPanelEvent(Object object) {
            super(object);
            this.isRunning = true;
        }

        public void setRunning(boolean bl) {
            this.isRunning = bl;
        }

        public void setReset(boolean bl) {
            this.isReset = bl;
        }
    }

    public static interface ClockPanelListener
    extends EventListener {
    }

    private class StartStopActionListener
    implements ActionListener {
        private StartStopActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.toggle();
        }

        private void toggle() {
            if (ClockPanelLarge.this.state == 0) {
                ClockPanelLarge.this.model.addModelElement(ClockPanelLarge.this.modelTickCounter);
                ClockPanelEvent clockPanelEvent = new ClockPanelEvent(this);
                clockPanelEvent.setRunning(true);
                ClockPanelLarge.this.resetBtn.setEnabled(false);
                ClockPanelLarge.this.state = 1;
            } else {
                ClockPanelLarge.this.model.removeModelElement(ClockPanelLarge.this.modelTickCounter);
                ClockPanelEvent clockPanelEvent = new ClockPanelEvent(this);
                clockPanelEvent.setRunning(false);
                ClockPanelLarge.this.resetBtn.setEnabled(true);
                ClockPanelLarge.this.state = 0;
            }
            ClockPanelLarge.this.startStopBtn.setText(ClockPanelLarge.this.startStopStr[ClockPanelLarge.this.state]);
        }
    }
}

