/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.model;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.sound.model.AttenuationFunction;
import edu.colorado.phet.sound.model.SphericalWavefront;
import edu.colorado.phet.sound.model.WaveFunction;
import edu.colorado.phet.sound.model.WavefrontType;

public class Wavefront
extends SimpleObservable {
    private WaveFunction waveFunction;
    private WavefrontType wavefrontType = new SphericalWavefront();
    private double maxAmplitude = 0.5;
    private double frequency = 25.0;
    private double[] amplitude = new double[s_length];
    private double[] frequencyAtTime = new double[s_length];
    private double[] maxAmplitudeAtTime = new double[s_length];
    private double[] prevFrequencyAtTime = new double[s_length];
    private double[] prevMaxAmplitudeAtTime = new double[s_length];
    private float time = 0.0f;
    private int propagationSpeed = 1;
    private boolean enabled = true;
    private int listenerLocation;
    public static int s_length = 400;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setWaveFunction(WaveFunction waveFunction) {
        this.waveFunction = waveFunction;
    }

    public void stepInTime(double d, AttenuationFunction attenuationFunction) {
        this.time = (float)((double)this.time + d);
        int n = this.propagationSpeed;
        for (int i = s_length - 1; i > n - 1; --i) {
            if (i - n == this.listenerLocation && this.maxAmplitudeAtTime[i] != this.prevMaxAmplitudeAtTime[i]) {
                this.notifyObservers();
            }
            this.prevMaxAmplitudeAtTime[i] = this.maxAmplitudeAtTime[i];
            this.amplitude[i] = this.amplitude[i - n];
            this.amplitude[i] = this.wavefrontType.computeAmplitudeAtDistance(this, this.amplitude[i], i) * attenuationFunction.getAttenuation(i * this.propagationSpeed, 0.0);
            if (i - n == this.listenerLocation && this.frequencyAtTime[i] != this.prevFrequencyAtTime[i]) {
                this.notifyObservers();
            }
            this.prevFrequencyAtTime[i] = this.frequencyAtTime[i];
            this.frequencyAtTime[i] = this.frequencyAtTime[i - n];
            this.maxAmplitudeAtTime[i] = this.maxAmplitudeAtTime[i - n];
            this.maxAmplitudeAtTime[i] = this.wavefrontType.computeAmplitudeAtDistance(this, this.maxAmplitudeAtTime[i], i) * attenuationFunction.getAttenuation(i * this.propagationSpeed, 0.0);
            if (!(this.maxAmplitudeAtTime[i] < 0.0)) continue;
            throw new RuntimeException("Negative amplitude");
        }
        double d2 = this.waveFunction.waveAmplitude(this.time);
        for (int i = 0; i < n; ++i) {
            this.amplitude[i] = d2;
            if (this.frequencyAtTime[i] != this.frequency) {
                this.frequencyAtTime[i] = this.frequency;
            }
            if (this.maxAmplitudeAtTime[i] == this.maxAmplitude) continue;
            this.maxAmplitudeAtTime[i] = this.maxAmplitude;
        }
    }

    public void setPropagationSpeed(int n) {
        this.propagationSpeed = n;
    }

    public double[] getAmplitude() {
        return this.amplitude;
    }

    public double getMaxAmplitude() {
        return this.maxAmplitude;
    }

    public void setMaxAmplitude(double d) {
        this.maxAmplitude = d;
        this.notifyObservers();
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double d) {
        this.frequency = d;
        this.notifyObservers();
    }

    public double getFrequencyAtTime(int n) {
        n = Math.max(0, Math.min(s_length - 1, n));
        return this.frequencyAtTime[n];
    }

    public double getMaxAmplitudeAtTime(int n) {
        n = Math.max(0, Math.min(s_length - 1, n));
        return this.maxAmplitudeAtTime[n];
    }

    public double getWavelengthAtTime(int n) {
        double d = (double)this.propagationSpeed / (5.0 * this.getFrequencyAtTime(n));
        return d * 6.2;
    }

    public void clear() {
        for (int i = 0; i < s_length; ++i) {
            this.amplitude[i] = 0.0;
            this.frequencyAtTime[i] = 0.0;
            this.maxAmplitudeAtTime[i] = 0.0;
        }
        this.notifyObservers();
    }
}

