/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.help.HelpItem;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.sound.SingleSourceModule;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.SoundResources;
import edu.colorado.phet.sound.view.ClockPanelLarge;
import edu.colorado.phet.sound.view.MeasureControlPanel;
import edu.colorado.phet.sound.view.MeterStickGraphic;
import edu.colorado.phet.sound.view.VerticalGuideline;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JDialog;

public class SingleSourceMeasureModule
extends SingleSourceModule {
    private JDialog stopwatchDlg;
    private final IClock clock;
    private final Point dragPoint = new Point();

    protected SingleSourceMeasureModule(PhetApplication phetApplication) {
        super(SoundResources.getString("ModuleTitle.SingleSourceMeasure"));
        Object object;
        Object object2;
        Object object3;
        this.clock = this.getClock();
        ApparatusPanel apparatusPanel = (ApparatusPanel)this.getSimulationPanel();
        try {
            object3 = ImageLoader.loadBufferedImage("sound/images/five-meter-stick.gif");
            object2 = new PText(SoundResources.getString("Units.Meters"), (BufferedImage)object3){
                final /* synthetic */ BufferedImage val$bi;
                {
                    this.val$bi = bufferedImage;
                    super(string);
                    this.setOffset(245.0, (double)(this.val$bi.getHeight() / 2) - this.getFullBounds().getHeight() / 2.0 + 2.0);
                }
            };
            object = ((BufferedImage)object3).createGraphics();
            ((PNode)object2).fullPaint(new PPaintContext((Graphics2D)object));
            ((Graphics)object).dispose();
            PhetImageGraphic phetImageGraphic = new PhetImageGraphic(apparatusPanel, (BufferedImage)object3);
            phetImageGraphic.setLocation(SoundConfig.s_meterStickBaseX, SoundConfig.s_meterStickBaseY);
            MeterStickGraphic meterStickGraphic = new MeterStickGraphic(apparatusPanel, phetImageGraphic, new Point2D.Double(SoundConfig.s_meterStickBaseX, SoundConfig.s_meterStickBaseY));
            apparatusPanel.addGraphic(meterStickGraphic, 9.0);
            HelpItem helpItem = new HelpItem(apparatusPanel, SoundResources.getString("SingleSourceMeasureModule.Help1"), SoundConfig.s_meterStickBaseX, SoundConfig.s_meterStickBaseY + phetImageGraphic.getImage().getHeight(), 5, 2);
            helpItem.setForegroundColor(Color.white);
            this.addHelpItem(helpItem);
            HelpItem helpItem2 = new HelpItem(apparatusPanel, SoundResources.getString("SingleSourceMeasureModule.Help2"), 100.0, 70.0, 5, 1);
            helpItem2.setForegroundColor(Color.white);
            this.addHelpItem(helpItem2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object3 = new VerticalGuideline(apparatusPanel, Color.blue, 70);
        apparatusPanel.addGraphic((PhetGraphic)object3, 10.0);
        object2 = new VerticalGuideline(apparatusPanel, Color.blue, 90);
        apparatusPanel.addGraphic((PhetGraphic)object2, 10.0);
        this.setControlPanel(new MeasureControlPanel(this));
        this.stopwatchDlg = new JDialog(phetApplication.getPhetFrame(), "Stopwatch", false);
        object = new ClockPanelLarge(this.getSoundModel());
        ((ClockPanelLarge)object).addListener(new StopwatchListener(this));
        this.stopwatchDlg.setContentPane((Container)object);
        this.stopwatchDlg.setLocation(0, 0);
        this.stopwatchDlg.setLocationRelativeTo(phetApplication.getPhetFrame());
        this.stopwatchDlg.setUndecorated(true);
        this.stopwatchDlg.setResizable(false);
        this.stopwatchDlg.getRootPane().setWindowDecorationStyle(2);
        this.stopwatchDlg.pack();
        this.stopwatchDlg.setDefaultCloseOperation(0);
        this.stopwatchDlg.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ((SingleSourceMeasureModule)SingleSourceMeasureModule.this).dragPoint.x = mouseEvent.getX();
                ((SingleSourceMeasureModule)SingleSourceMeasureModule.this).dragPoint.y = mouseEvent.getY();
            }
        });
        this.stopwatchDlg.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = SingleSourceMeasureModule.this.stopwatchDlg.getLocation();
                SingleSourceMeasureModule.this.stopwatchDlg.setLocation(point.x + mouseEvent.getX() - ((SingleSourceMeasureModule)SingleSourceMeasureModule.this).dragPoint.x, point.y + mouseEvent.getY() - ((SingleSourceMeasureModule)SingleSourceMeasureModule.this).dragPoint.y);
            }
        });
        ((Component)object).setCursor(Cursor.getPredefinedCursor(12));
    }

    public boolean hasHelp() {
        return true;
    }

    public void activate() {
        super.activate();
        this.stopwatchDlg.setVisible(true);
    }

    public void deactivate() {
        super.deactivate();
        this.setStopwatchVisible(false);
    }

    public void setStopwatchVisible(boolean bl) {
        this.stopwatchDlg.setVisible(bl);
    }

    public void clearWaves() {
        this.resetWaveMediumGraphic();
        if (this.clock.isPaused()) {
            this.clock.stepClockWhilePaused();
        }
    }

    public class StopwatchListener
    implements ClockPanelLarge.ClockPanelListener {
        SingleSourceMeasureModule module;

        public StopwatchListener(SingleSourceMeasureModule singleSourceMeasureModule2) {
            this.module = singleSourceMeasureModule2;
        }
    }
}

